/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.mixin;

import com.oitsjustjose.vtweaks.common.config.CommonConfig;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class DestroySpeedMixin {
    @Inject(at={@At(value="HEAD")}, method={"getDestroySpeed"}, cancellable=true)
    public void getDestroySpeed(ItemStack stack, BlockState state, CallbackInfoReturnable<Float> cir) {
        Tool tool;
        if (((Boolean)CommonConfig.EnableDestroySpeedMixin.get()).booleanValue() && (tool = (Tool)stack.get(DataComponents.TOOL)) != null) {
            float speed = tool.getMiningSpeed(state);
            if (stack.isDamageableItem()) {
                int maxDamage = stack.getMaxDamage();
                int currentDamage = stack.getDamageValue();
                float scale = 1.0f - (float)currentDamage / (float)maxDamage;
                cir.setReturnValue((Object)Float.valueOf(speed * Math.max(scale, 0.2f)));
            }
        }
    }
}

