/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.mixin;

import com.oitsjustjose.vtweaks.common.config.CommonConfig;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipeInput;
import com.oitsjustjose.vtweaks.common.registries.ModRecipeTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownPotion.class})
public abstract class ThrownPotionMixin {
    @Inject(at={@At(value="HEAD")}, method={"dowseFire(Lnet/minecraft/core/BlockPos;)V"})
    protected void onHitBlock(BlockPos pos, CallbackInfo ci) {
        if (((Boolean)CommonConfig.EnableSplashPotionMixin.get()).booleanValue()) {
            Item item;
            Entity base = (Entity)this;
            BlockState state = base.level().getBlockState(pos);
            Item item2 = state.getBlock().asItem();
            Optional<RecipeHolder<FluidConversionRecipe>> foundRecipe = this.v_Tweaks$findRecipe(base.level(), new ItemStack((ItemLike)item2));
            if (foundRecipe.isEmpty()) {
                return;
            }
            FluidConversionRecipe recipe = (FluidConversionRecipe)foundRecipe.get().value();
            if (recipe.getFluid().getPath().equalsIgnoreCase("water") && (item = recipe.getResult().getItem()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                base.level().setBlock(pos, blockItem.getBlock().withPropertiesOf(state), 3);
            }
        }
    }

    @Unique
    public Optional<RecipeHolder<FluidConversionRecipe>> v_Tweaks$findRecipe(Level level, ItemStack item) {
        FluidConversionRecipeInput input = new FluidConversionRecipeInput(item);
        return level.getRecipeManager().getRecipeFor(ModRecipeTypes.FLUID_CONVERSION.get(), (RecipeInput)input, level);
    }
}

