/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.recipe;

import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipeInput;
import com.oitsjustjose.vtweaks.common.entity.ConvertibleItemEntity;
import com.oitsjustjose.vtweaks.common.registries.ModRecipeTypes;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class FluidConversionDispensing
extends DefaultDispenseItemBehavior {
    @NotNull
    public ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
        Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        Position pos = DispenserBlock.getDispensePosition((BlockSource)source);
        ItemStack itemStack = stack.split(1);
        this.dispense(source, itemStack, 6, facing, pos);
        return stack;
    }

    public void dispense(@NotNull BlockSource source, ItemStack stack, int speed, Direction facing, Position pos) {
        List<RecipeHolder<FluidConversionRecipe>> recipes = this.findRecipes((Level)source.level(), stack);
        if (recipes.isEmpty()) {
            super.dispense(source, stack);
            return;
        }
        double d0 = pos.x();
        double d1 = pos.y();
        double d2 = pos.z();
        ConvertibleItemEntity entityItem = new ConvertibleItemEntity(new ItemEntity((Level)source.level(), d0, d1 -= facing.getAxis() == Direction.Axis.Y ? 0.125 : 0.15625, d2, stack), recipes);
        double d3 = source.level().getRandom().nextDouble() * 0.1 + 0.2;
        double motX = (double)facing.getStepX() * d3;
        double motY = 0.2f;
        double motZ = (double)facing.getStepZ() * d3;
        entityItem.setDeltaMovement(motX += source.level().getRandom().nextGaussian() * (double)0.0075f * (double)speed, motY += source.level().getRandom().nextGaussian() * (double)0.0075f * (double)speed, motZ += source.level().getRandom().nextGaussian() * (double)0.0075f * (double)speed);
        entityItem.setNoPickUpDelay();
        source.level().addFreshEntity((Entity)entityItem);
    }

    public List<RecipeHolder<FluidConversionRecipe>> findRecipes(Level level, ItemStack stack) {
        FluidConversionRecipeInput input = new FluidConversionRecipeInput(stack);
        return level.getRecipeManager().getRecipesFor(ModRecipeTypes.FLUID_CONVERSION.get(), (RecipeInput)input, level);
    }
}

