/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.recipe;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.AnvilUpdateEvent;

@Tweak(category="recipes")
public class ItemRepairTweak
extends VTweak {
    public ModConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("Removes the scaling repair cost of items in an anvil").define("enableCheapAnvilRepair", true);
    }

    @SubscribeEvent
    public void process(AnvilUpdateEvent evt) {
        DiggerItem tool;
        if (evt.getLeft().isEmpty() || evt.getRight().isEmpty()) {
            return;
        }
        Item item = evt.getLeft().getItem();
        if (item instanceof DiggerItem && (tool = (DiggerItem)item).getTier().getRepairIngredient().test(evt.getRight())) {
            evt.getLeft().remove(DataComponents.REPAIR_COST);
            evt.setCost(0L);
        }
    }
}

