/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.world;

import com.google.common.collect.Lists;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

@Tweak(category="world.peacefulsurface")
public class PeacefulSurfaceTweak
extends VTweak {
    public static final TagKey<EntityType<?>> BLACKLISTED_ENTITIES = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vtweaks", (String)"ignored_by_peaceful_surface"));
    public static final TagKey<DimensionType> BLACKLISTED_DIMENSIONS = TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"vtweaks", (String)"peaceful_surface_blacklist_dims"));
    private ModConfigSpec.BooleanValue enabled;
    private ModConfigSpec.IntValue minY;
    private ModConfigSpec.ConfigValue<List<String>> moonPhases;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        String moonPhaseList = Arrays.stream(MoonPhase.values()).map(Enum::toString).collect(Collectors.joining(", "));
        this.enabled = builder.comment("Prevents mobs from spawning above the configured sea level on nights of the configured moon phases").define("enabled", false);
        this.minY = builder.comment("The configured 'sea level' which mobs will be prevented from spawning").defineInRange("seaLevel", 60, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.moonPhases = builder.comment("Peaceful Surface will only apply on nights whose moon phases are contained in this list (by default, all nights except for New Moons are going to be peaceful).\nOptions can include: " + moonPhaseList).define("moonPhasesToApplyTo", (Object)Lists.newArrayList((Object[])new String[]{MoonPhase.FULL.toString(), MoonPhase.WANING_GIBBOUS.toString(), MoonPhase.LAST_QUARTER.toString(), MoonPhase.WANING_CRESCENT.toString(), MoonPhase.WAXING_CRESCENT.toString(), MoonPhase.FIRST_QUARTER.toString(), MoonPhase.WAXING_GIBBOUS.toString()}));
    }

    @SubscribeEvent
    public void process(MobSpawnEvent.SpawnPlacementCheck evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getSpawnType() != MobSpawnType.NATURAL) {
            return;
        }
        if (evt.getEntityType().getCategory() != MobCategory.MONSTER) {
            return;
        }
        if (evt.getEntityType().is(BLACKLISTED_ENTITIES)) {
            return;
        }
        ServerLevelAccessor serverLevelAccessor = evt.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)serverLevelAccessor;
        if (level.dimensionTypeRegistration().is(BLACKLISTED_DIMENSIONS)) {
            return;
        }
        String currentPhase = MoonPhase.values()[level.getMoonPhase()].toString();
        if (((List)this.moonPhases.get()).stream().noneMatch(moonPhase -> Objects.equals(moonPhase, currentPhase))) {
            return;
        }
        if (evt.getPos().getY() >= (Integer)this.minY.get()) {
            evt.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
        }
    }

    public static enum MoonPhase {
        FULL,
        WANING_GIBBOUS,
        LAST_QUARTER,
        WANING_CRESCENT,
        NEW,
        WAXING_CRESCENT,
        FIRST_QUARTER,
        WAXING_GIBBOUS;

    }
}

