/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.world;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@Tweak(category="world")
public class StormDisableTweak
extends VTweak {
    private ModConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ModConfigSpec.Builder builder) {
        super.registerConfigs(builder);
        this.enabled = builder.comment("Disables thunder storms, converting storms to normal rain").define("enableStormTweak", true);
    }

    @SubscribeEvent
    public void process(LevelTickEvent.Pre evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (!evt.getLevel().getLevelData().isThundering()) {
            return;
        }
        LevelData levelData = evt.getLevel().getLevelData();
        if (!(levelData instanceof ServerLevelData)) {
            return;
        }
        ServerLevelData levelData2 = (ServerLevelData)levelData;
        levelData2.setThundering(false);
    }
}

