/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.integration.jei;

import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import com.oitsjustjose.vtweaks.common.util.I18n;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class FluidConversionRecipeCategory
implements IRecipeCategory<FluidConversionRecipe> {
    public static final RecipeType<FluidConversionRecipe> TYPE = RecipeType.create((String)"vtweaks", (String)"fluid_conversion", FluidConversionRecipe.class);
    public static final ItemStack SPLASH_POTION = PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.WATER.getDelegate());
    private final IDrawable background;
    private final IDrawable icon;

    public FluidConversionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"vtweaks", (String)"textures/gui/fluid_conversion.png"), 0, 0, 76, 18).addPadding(0, 20, 32, 32).setTextureSize(76, 18).build();
        this.icon = guiHelper.createDrawableItemStack(SPLASH_POTION);
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    @Nonnull
    public RecipeType<FluidConversionRecipe> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return I18n.Translate("vtweaks.fluid_conversion.jei.title");
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, FluidConversionRecipe recipe, @NotNull IFocusGroup focuses) {
        Ingredient input = recipe.getInput();
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(recipe.getFluid());
        ItemStack output = recipe.getResult();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 33, 1).addIngredients(input)).setSlotName("inputSlot");
        builder.addSlot(RecipeIngredientRole.CATALYST, 33, 1).addFluidStack(fluid, 1000L).setSlotName("fluidSlot");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).addItemStack(output)).setSlotName("outputSlot");
    }

    public void draw(FluidConversionRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(recipe.getFluid());
        Component fluidNm = I18n.Resolve(fluid.getFluidType().getDescription().getContents());
        Component comp = I18n.Translate("vtweaks.fluid_conversion.jei.text", fluidNm);
        Minecraft minecraft = Minecraft.getInstance();
        int width = minecraft.font.width((FormattedText)comp);
        int x = this.background.getWidth() - 2 - width;
        int y = 27;
        guiGraphics.drawString(minecraft.font, comp, x + 1, y + 1, 0x25252525);
        guiGraphics.drawString(minecraft.font, comp, x, y, 0x252525);
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

