/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.integration.jei;

import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.data.anvil.AnvilRecipe;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import com.oitsjustjose.vtweaks.common.registries.ModRecipeTypes;
import com.oitsjustjose.vtweaks.common.util.I18n;
import com.oitsjustjose.vtweaks.integration.jei.FluidConversionRecipeCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"vtweaks", (String)"jei_recipes");

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack dispenser = new ItemStack((ItemLike)Blocks.DISPENSER);
        MutableComponent comp = I18n.Translate("vtweaks.dispenser.jei.title").plainCopy().withStyle(ChatFormatting.RESET);
        dispenser.set(DataComponents.ITEM_NAME, (Object)comp);
        registration.addRecipeCatalyst(dispenser, new RecipeType[]{FluidConversionRecipeCategory.TYPE});
        HashSet<ResourceLocation> fluids = new HashSet<ResourceLocation>();
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(ModRecipeTypes.FLUID_CONVERSION.get())) {
            fluids.add(((FluidConversionRecipe)recipe.value()).getFluid());
        }
        for (ResourceLocation fluidKey : fluids) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidKey);
            Item bucket = fluid.getBucket();
            if (bucket == Items.AIR) continue;
            registration.addRecipeCatalyst(new ItemStack((ItemLike)bucket), new RecipeType[]{FluidConversionRecipeCategory.TYPE});
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidConversionRecipeCategory(guiHelper)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            VTweaks.getInstance().LOGGER.info("Client level is null! JEI plugin will not work");
            return;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        registration.addRecipes(RecipeTypes.ANVIL, this.generateAnvilRecipes(registration, recipeManager));
        registration.addRecipes(FluidConversionRecipeCategory.TYPE, this.generateFluidConversionRecipes(recipeManager));
    }

    private List<IJeiAnvilRecipe> generateAnvilRecipes(IRecipeRegistration registration, RecipeManager mgr) {
        ArrayList ret = Lists.newArrayList();
        for (RecipeHolder recipe : mgr.getAllRecipesFor(ModRecipeTypes.ANVIL.get())) {
            List<ItemStack> left = Arrays.asList(((AnvilRecipe)recipe.value()).getLeft().getItems());
            List<ItemStack> right = Arrays.asList(((AnvilRecipe)recipe.value()).getRight().getItems());
            List<ItemStack> result = List.of(((AnvilRecipe)recipe.value()).getResult());
            ret.add(registration.getVanillaRecipeFactory().createAnvilRecipe(left, right, result, recipe.id()));
        }
        return ret;
    }

    private List<FluidConversionRecipe> generateFluidConversionRecipes(RecipeManager mgr) {
        return mgr.getAllRecipesFor(ModRecipeTypes.FLUID_CONVERSION.get()).stream().map(RecipeHolder::value).toList();
    }
}

