/*
 * Decompiled with CFR 0.152.
 */
package net.paulem.simpleores.bucket.tint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_10401;
import net.minecraft.class_10410;
import net.minecraft.class_1058;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7764;
import net.minecraft.class_9848;
import net.paulem.simpleores.bucket.tint.handler.BucketLayerTintSource;
import net.paulem.simpleores.items.custom.bucket.CustomChildrenBucketItem;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientBucketUtil {
    private static final Map<class_3611, Integer> DOMINANT_COLOR_CACHE = new ConcurrentHashMap<class_3611, Integer>();
    private static final Map<String, Integer> COLOR_AT_CACHE = new ConcurrentHashMap<String, Integer>();
    private static final int OVERLAY_COORDS_Y_OFFSET = 4;
    private static final List<List<Integer>> OVERLAY_COORDS = Arrays.asList(Arrays.asList(4, 5, 6, 7, 8, 9, 10, 11), Arrays.asList(3, 4, 5, 6, 7, 8, 9, 10, 11, 12), Arrays.asList(5, 6, 7, 8, 9, 10));

    public static class_3611 getContainedFluid(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof CustomChildrenBucketItem) {
            CustomChildrenBucketItem bucketItem = (CustomChildrenBucketItem)item;
            return bucketItem.method_74140();
        }
        return class_3612.field_15906;
    }

    public static int getWaterLikeColor(class_3611 fluid, int defaultColor) {
        FluidRenderHandler fluidRenderHandler;
        int color = class_9848.method_61330((int)255, (int)defaultColor);
        if (fluid == class_3612.field_15906 || (fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluid)) == null) {
            return color;
        }
        int handlerColor = fluidRenderHandler.getFluidColor(null, null, fluid.method_15785());
        color = class_9848.method_61330((int)255, (int)handlerColor);
        if (color == -1) {
            Integer dominant;
            Integer cached = DOMINANT_COLOR_CACHE.get(fluid);
            if (cached != null) {
                return class_9848.method_61330((int)255, (int)cached);
            }
            class_1058[] sprites = fluidRenderHandler.getFluidSprites(null, null, fluid.method_15785());
            if (sprites != null && sprites.length > 0 && sprites[0] != null && (dominant = ClientBucketUtil.computeDominantOpaqueColor(sprites[0])) != null) {
                DOMINANT_COLOR_CACHE.put(fluid, dominant);
                return class_9848.method_61330((int)255, (int)dominant);
            }
        }
        return color;
    }

    private static Integer computeDominantOpaqueColor(class_1058 sprite) {
        try {
            int frame = 0;
            int width = sprite.method_45851().method_45807();
            int height = sprite.method_45851().method_45815();
            if (width <= 0 || height <= 0) {
                return null;
            }
            class_7764 contents = sprite.method_45851();
            HashMap<Integer, Integer> colorCount = new HashMap<Integer, Integer>();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int argb = ClientBucketUtil.getPixelColor(contents, frame, 0, x, y);
                    int a = argb >>> 24 & 0xFF;
                    if (a <= 16) continue;
                    int rgb = argb & 0xFFFFFF;
                    colorCount.put(rgb, colorCount.getOrDefault(rgb, 0) + 1);
                }
            }
            int dominantColor = 0;
            int maxCount = 0;
            for (Map.Entry entry : colorCount.entrySet()) {
                if ((Integer)entry.getValue() <= maxCount) continue;
                maxCount = (Integer)entry.getValue();
                dominantColor = (Integer)entry.getKey();
            }
            return maxCount > 0 ? Integer.valueOf(dominantColor) : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static int getColorAt(class_3611 fluid, int defaultColor, int x, int y) {
        Integer at;
        FluidRenderHandler fluidRenderHandler;
        int color = class_9848.method_61330((int)255, (int)defaultColor);
        String cacheKey = fluid.toString() + ":" + x + ":" + y;
        Integer cached = COLOR_AT_CACHE.get(cacheKey);
        if (cached != null) {
            return class_9848.method_61330((int)255, (int)cached);
        }
        if (fluid == class_3612.field_15906 || (fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluid)) == null) {
            return color;
        }
        class_1058[] sprites = fluidRenderHandler.getFluidSprites(null, null, fluid.method_15785());
        if (sprites != null && sprites.length > 0 && sprites[0] != null && (at = ClientBucketUtil.getColorAt(sprites[0], x, y)) != null) {
            COLOR_AT_CACHE.put(cacheKey, at);
            return class_9848.method_61330((int)255, (int)at);
        }
        COLOR_AT_CACHE.put(cacheKey, color);
        return color;
    }

    private static Integer getColorAt(class_1058 sprite, int x, int y) {
        try {
            int frame = 0;
            int width = sprite.method_45851().method_45807();
            int height = sprite.method_45851().method_45815();
            if (width <= 0 || height <= 0) {
                return null;
            }
            class_7764 contents = sprite.method_45851();
            int argb = ClientBucketUtil.getPixelColor(contents, frame, 0, x, y);
            int a = argb >>> 24 & 0xFF;
            if (a <= 16) {
                return 65280;
            }
            int rgb = argb & 0xFFFFFF;
            return rgb;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static int getPixelColor(class_7764 contents, int frameIndex, int layer, int x, int y) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable class_7764.class_5790 animation = contents.field_40541;
        if (animation == null) {
            return ClientBucketUtil.getNotAnimatedPixelColor(contents, layer, x, y);
        }
        return ClientBucketUtil.getAnimatedPixelColor(contents, animation, frameIndex, layer, x, y);
    }

    private static int getNotAnimatedPixelColor(class_7764 contents, int layer, int x, int y) {
        return contents.field_40540[layer].method_61940(x, y);
    }

    private static int getAnimatedPixelColor(class_7764 contents, class_7764.class_5790 animation, int frameIndex, int layer, int x, int y) {
        return contents.field_40540[layer].method_61940(x + (animation.method_33446(frameIndex) * contents.method_45807() >> layer), y + (animation.method_33451(frameIndex) * contents.method_45815() >> layer));
    }

    public static class_10401[] getDefaultTints(CustomChildrenBucketItem child) {
        ArrayList<class_10401> tintSources = new ArrayList<class_10401>();
        tintSources.add(class_10410.method_65480((int)-1));
        for (List<Integer> row : OVERLAY_COORDS) {
            for (Integer x : row) {
                int y = OVERLAY_COORDS.indexOf(row) + 4;
                BucketLayerTintSource tintSource = new BucketLayerTintSource(class_9848.method_61330((int)255, (int)0xFFFFFF), x, y);
                tintSources.add(tintSource);
            }
        }
        return tintSources.toArray(new class_10401[0]);
    }
}

