/*
 * Decompiled with CFR 0.152.
 */
package ovh.paulem.simpleores.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;

public class ConcurrentFifoMap<K, V> {
    private final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<K> order = new ConcurrentLinkedQueue();
    private final int maxSize;

    public ConcurrentFifoMap() {
        this(0);
    }

    public ConcurrentFifoMap(int maxSize) {
        this.maxSize = maxSize;
    }

    public V put(K key, V value) {
        V prev = this.map.put(key, value);
        if (prev == null) {
            this.order.add(key);
            this.evictIfNeeded();
        }
        return prev;
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public V remove(K key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public void forEach(BiConsumer<K, V> consumer) {
        LinkedHashSet<K> seen = new LinkedHashSet<K>();
        for (K k : this.order) {
            V v;
            if (!seen.add(k) || (v = this.map.get(k)) == null) continue;
            consumer.accept(k, v);
        }
    }

    public Collection<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        LinkedHashSet<K> seen = new LinkedHashSet<K>();
        for (K k : this.order) {
            V v;
            if (!seen.add(k) || (v = this.map.get(k)) == null) continue;
            list.add(v);
        }
        return list;
    }

    private void evictIfNeeded() {
        K oldest;
        if (this.maxSize <= 0) {
            return;
        }
        while (this.map.size() > this.maxSize && (oldest = this.order.poll()) != null) {
            this.map.remove(oldest);
        }
    }
}

