/*
 * Decompiled with CFR 0.152.
 */
package net.paulem.simpleores.datagen;

import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7877;
import net.minecraft.class_7924;
import net.paulem.simpleores.datagen.providers.AdvancementsProvider;
import net.paulem.simpleores.datagen.providers.LootTableProvider;
import net.paulem.simpleores.datagen.providers.ModelProvider;
import net.paulem.simpleores.datagen.providers.RecipeProvider;
import net.paulem.simpleores.datagen.providers.WorldGenProvider;
import net.paulem.simpleores.datagen.providers.langs.ChineseSimplifiedLangProvider;
import net.paulem.simpleores.datagen.providers.langs.ChineseTraditionalLangProvider;
import net.paulem.simpleores.datagen.providers.langs.DanishLangProvider;
import net.paulem.simpleores.datagen.providers.langs.EnglishLangProvider;
import net.paulem.simpleores.datagen.providers.langs.FrenchLangProvider;
import net.paulem.simpleores.datagen.providers.langs.PortugueseBresilianLangProvider;
import net.paulem.simpleores.datagen.providers.langs.SpanishArgentinaLangProvider;
import net.paulem.simpleores.datagen.providers.langs.SpanishSpainLangProvider;
import net.paulem.simpleores.datagen.providers.langs.TurkeyLangProvider;
import net.paulem.simpleores.datagen.providers.langs.UkrainianLangProvider;
import net.paulem.simpleores.datagen.providers.tags.BlockTagProvider;
import net.paulem.simpleores.datagen.providers.tags.ItemTagProvider;
import net.paulem.simpleores.world.ModConfiguredFeatures;
import net.paulem.simpleores.world.ModPlacedFeatures;

@Environment(value=EnvType.CLIENT)
public class SimpleOresDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ModelProvider::new);
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(BlockTagProvider::new);
        pack.addProvider(ItemTagProvider::new);
        pack.addProvider(WorldGenProvider::new);
        pack.addProvider(LootTableProvider::new);
        pack.addProvider(AdvancementsProvider::new);
        List<FabricDataGenerator.Pack.RegistryDependentFactory> langs = Arrays.asList(ChineseSimplifiedLangProvider::new, ChineseTraditionalLangProvider::new, EnglishLangProvider::new, FrenchLangProvider::new, DanishLangProvider::new, PortugueseBresilianLangProvider::new, SpanishArgentinaLangProvider::new, SpanishSpainLangProvider::new, TurkeyLangProvider::new, UkrainianLangProvider::new);
        for (FabricDataGenerator.Pack.RegistryDependentFactory lang : langs) {
            pack.addProvider(lang);
        }
    }

    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, ModConfiguredFeatures::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, ModPlacedFeatures::bootstrap);
    }
}

