/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.blay09.mods.inventoryessentials.client.ClientInventorySorting;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class ClientOnlyInventoryControls
implements InventoryControls {
    @Override
    public boolean singleTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        AbstractContainerMenu menu = screen.getMenu();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        if (!clickedSlot.mayPickup((Player)player)) {
            return false;
        }
        ItemStack targetStack = clickedSlot.getItem().copy();
        if (targetStack.getCount() == 1) {
            this.slotClick(menu, clickedSlot, 0, ClickType.QUICK_MOVE);
            return true;
        }
        Slot fallbackSlot = null;
        for (Slot slot : menu.slots) {
            ItemStack stack = slot.getItem();
            if (!this.isValidTargetSlot(slot) || slot == clickedSlot || !slot.mayPlace(targetStack) || InventoryUtils.isSameInventory(clickedSlot, slot) || stack.getCount() >= Math.min(slot.getMaxStackSize(), slot.getMaxStackSize(stack))) continue;
            if (ItemStack.isSameItemSameComponents((ItemStack)targetStack, (ItemStack)stack)) {
                this.slotClick(menu, clickedSlot, 1, ClickType.PICKUP);
                this.slotClick(menu, slot, 1, ClickType.PICKUP);
                this.slotClick(menu, clickedSlot, 0, ClickType.PICKUP);
                return true;
            }
            if (slot.hasItem() || fallbackSlot != null) continue;
            fallbackSlot = slot;
        }
        if (fallbackSlot != null) {
            this.slotClick(menu, clickedSlot, 1, ClickType.PICKUP);
            this.slotClick(menu, fallbackSlot, 1, ClickType.PICKUP);
            this.slotClick(menu, clickedSlot, 0, ClickType.PICKUP);
            return true;
        }
        return false;
    }

    @Override
    public boolean bulkTransferByType(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        ItemStack clickedStackCopy = clickedSlot.getItem().copy();
        clickedStackCopy.setDamageValue(0);
        AbstractContainerMenu menu = screen.getMenu();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(clickedSlot);
        for (Slot slot : menu.slots) {
            if (slot == clickedSlot || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot)) continue;
            ItemStack slotStackCopy = slot.getItem();
            slotStackCopy.setDamageValue(0);
            if (!ItemStack.isSameItemSameComponents((ItemStack)clickedStackCopy, (ItemStack)slotStackCopy)) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 0, ClickType.QUICK_MOVE);
        }
        return true;
    }

    @Override
    public boolean bulkTransferSingle(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        Equippable clickedEquippable;
        if (!clickedSlot.hasItem() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = screen.getMenu();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.container instanceof Inventory)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
        }
        boolean clickedAnArmorItem = (clickedEquippable = (Equippable)clickedSlot.getItem().get(DataComponents.EQUIPPABLE)) != null && clickedEquippable.slot().isArmor();
        boolean isInsideInventory = menu instanceof InventoryMenu;
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
            ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
            for (Slot slot : menu.slots) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.container instanceof Inventory) || !this.isValidTargetSlot(slot)) continue;
                if (slot.hasItem()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (Inventory.isHotbarSlot((int)slot.getContainerSlot())) continue;
                emptySlots.add(slot);
            }
            for (Slot slot : menu.slots) {
                if (!slot.mayPickup((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.quickTransferSingle(menu, emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else if (clickedAnArmorItem && isInsideInventory) {
            if (!InventoryEssentialsConfig.getActive().bulkTransferArmorSets) {
                return false;
            }
            if (!menu.getCarried().isEmpty()) {
                return false;
            }
            if (clickedSlot.index >= 5 && clickedSlot.index < 9) {
                for (int i = 5; i < 9; ++i) {
                    this.slotClick(menu, i, 0, ClickType.QUICK_MOVE);
                }
                return true;
            }
            Map<EquipmentSlot, Slot> armorSlots = InventoryUtils.findMatchingArmorSetSlots(menu, clickedSlot);
            List<EquipmentSlot> equipmentSlots = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            for (int i = 5; i < 9; ++i) {
                EquipmentSlot equipmentSlot = equipmentSlots.get(i - 5);
                Slot swapSlot = armorSlots.get(equipmentSlot);
                if (swapSlot == null) continue;
                this.slotClick(menu, i, 0, ClickType.PICKUP);
                this.slotClick(menu, swapSlot, 0, ClickType.PICKUP);
                this.slotClick(menu, i, 0, ClickType.PICKUP);
            }
            movedAny = true;
        } else {
            for (Slot slot : menu.slots) {
                if (!slot.mayPickup((Player)player) || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.singleTransfer(screen, slot);
                movedAny = true;
            }
        }
        return movedAny;
    }

    @Override
    public boolean bulkTransferAll(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        Equippable clickedEquippable;
        if (!clickedSlot.hasItem() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = screen.getMenu();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.container instanceof Inventory)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
        }
        boolean clickedAnArmorItem = (clickedEquippable = (Equippable)clickedSlot.getItem().get(DataComponents.EQUIPPABLE)) != null && clickedEquippable.slot().isArmor();
        boolean isInsideInventory = menu instanceof InventoryMenu;
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
            ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
            for (Slot slot : menu.slots) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.container instanceof Inventory) || !this.isValidTargetSlot(slot)) continue;
                if (slot.hasItem()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (Inventory.isHotbarSlot((int)slot.getContainerSlot())) continue;
                emptySlots.add(slot);
            }
            for (Slot slot : menu.slots) {
                if (!slot.mayPickup((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.quickTransferStack(menu, emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else if (clickedAnArmorItem && isInsideInventory) {
            if (!InventoryEssentialsConfig.getActive().bulkTransferArmorSets) {
                return false;
            }
            if (!menu.getCarried().isEmpty()) {
                return false;
            }
            if (clickedSlot.index >= 5 && clickedSlot.index < 9) {
                for (int i = 5; i < 9; ++i) {
                    this.slotClick(menu, i, 0, ClickType.QUICK_MOVE);
                }
                return true;
            }
            Map<EquipmentSlot, Slot> armorSlots = InventoryUtils.findMatchingArmorSetSlots(menu, clickedSlot);
            List<EquipmentSlot> equipmentSlots = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            for (int i = 5; i < 9; ++i) {
                EquipmentSlot equipmentSlot = equipmentSlots.get(i - 5);
                Slot swapSlot = armorSlots.get(equipmentSlot);
                if (swapSlot == null) continue;
                this.slotClick(menu, i, 0, ClickType.PICKUP);
                this.slotClick(menu, swapSlot, 0, ClickType.PICKUP);
                this.slotClick(menu, i, 0, ClickType.PICKUP);
            }
            movedAny = true;
        } else {
            for (Slot slot : menu.slots) {
                if (!slot.mayPickup((Player)player) || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.slotClick(menu, slot, 0, ClickType.QUICK_MOVE);
                movedAny = true;
            }
        }
        return movedAny;
    }

    private boolean quickTransferStack(AbstractContainerMenu menu, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        ItemStack targetStack = slot.getItem().copy();
        if (targetStack.isEmpty()) {
            return false;
        }
        this.slotClick(menu, slot, 0, ClickType.PICKUP);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = nonEmptySlot.getItem();
            if (!ItemStack.isSameItemSameComponents((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.getCount() < Math.min(nonEmptySlot.getMaxStackSize(), nonEmptySlot.getMaxStackSize(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(menu, nonEmptySlot, 0, ClickType.PICKUP);
            ItemStack mouseItem = menu.getCarried();
            if (!mouseItem.isEmpty()) continue;
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            this.slotClick(menu, emptySlot, 0, ClickType.PICKUP);
            if (emptySlot.hasItem()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = menu.getCarried()).isEmpty()) continue;
            return true;
        }
        ItemStack mouseItem = menu.getCarried();
        if (!mouseItem.isEmpty()) {
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
        }
        return false;
    }

    private boolean quickTransferSingle(AbstractContainerMenu menu, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        ItemStack targetStack = slot.getItem().copy();
        if (targetStack.isEmpty()) {
            return false;
        }
        this.slotClick(menu, slot, 0, ClickType.PICKUP);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = nonEmptySlot.getItem();
            if (!ItemStack.isSameItemSameComponents((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.getCount() < Math.min(nonEmptySlot.getMaxStackSize(), nonEmptySlot.getMaxStackSize(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(menu, nonEmptySlot, 1, ClickType.PICKUP);
            ItemStack mouseItem = menu.getCarried();
            if (mouseItem.getCount() >= targetStack.getCount()) continue;
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            this.slotClick(menu, emptySlot, 1, ClickType.PICKUP);
            if (emptySlot.hasItem()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if ((mouseItem = menu.getCarried()).getCount() >= targetStack.getCount()) continue;
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
            return true;
        }
        ItemStack mouseItem = menu.getCarried();
        if (!mouseItem.isEmpty()) {
            this.slotClick(menu, slot, 0, ClickType.PICKUP);
        }
        return false;
    }

    @Override
    public void dragTransfer(AbstractContainerScreen<?> screen, Slot clickedSlot) {
        this.slotClick(screen.getMenu(), clickedSlot, 0, ClickType.QUICK_MOVE);
    }

    @Override
    public void dragClick(AbstractContainerScreen<?> screen, Slot hoveredSlot, int mouseButton) {
        this.slotClick(screen.getMenu(), hoveredSlot, mouseButton, ClickType.PICKUP);
    }

    @Override
    public boolean sort(AbstractContainerScreen<?> screen, Slot baseSlot) {
        AbstractContainerMenu menu = screen.getMenu();
        return ClientInventorySorting.sort(menu, baseSlot, this::slotClick);
    }

    protected void slotClick(AbstractContainerMenu menu, Slot slot, int mouseButton, ClickType clickType) {
        this.slotClick(menu, slot.index, mouseButton, clickType);
    }

    protected void slotClick(AbstractContainerMenu menu, int slotIndex, int mouseButton, ClickType clickType) {
        LocalPlayer player = Minecraft.getInstance().player;
        MultiPlayerGameMode gameMode = Minecraft.getInstance().gameMode;
        if (player != null && gameMode != null && (slotIndex >= 0 && slotIndex < menu.slots.size() || slotIndex == -999)) {
            gameMode.handleInventoryMouseClick(menu.containerId, slotIndex, mouseButton, clickType, (Player)player);
        }
    }

    @Override
    public boolean dropByType(AbstractContainerScreen<?> screen, Slot hoverSlot) {
        ItemStack targetStack = hoverSlot.getItem().copy();
        AbstractContainerMenu menu = screen.getMenu();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(hoverSlot);
        for (Slot slot : menu.slots) {
            ItemStack stack;
            if (slot == hoverSlot || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, hoverSlot) || !ItemStack.isSameItemSameComponents((ItemStack)targetStack, (ItemStack)(stack = slot.getItem()))) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, ClickType.THROW);
        }
        return true;
    }

    @Override
    public boolean dropByType(AbstractContainerScreen<?> screen, ItemStack targetStack) {
        if (targetStack.isEmpty()) {
            return false;
        }
        AbstractContainerMenu menu = screen.getMenu();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        for (Slot slot : menu.slots) {
            ItemStack stack = slot.getItem();
            if (!ItemStack.isSameItemSameComponents((ItemStack)targetStack, (ItemStack)stack) || !this.isValidTargetSlot(slot)) continue;
            transferSlots.add(slot);
        }
        this.slotClick(menu, -999, 0, ClickType.PICKUP);
        for (Slot transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, ClickType.THROW);
        }
        return true;
    }

    protected boolean isValidTargetSlot(Slot slot) {
        return true;
    }
}

