/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryEssentialsIgnores;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.CreativeInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ModKeyMappings;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls creativeControls = new CreativeInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static Slot lastDragHoverSlot;
    private static boolean hasDragClicked;

    public static void initialize() {
        ModKeyMappings.initialize();
        Balm.getEvents().onEvent(ScreenMouseEvent.Drag.Pre.class, InventoryEssentialsClient::onMouseDrag);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, InventoryEssentialsClient::onMouseRelease);
    }

    public static InventoryControls getInventoryControls(Screen screen) {
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            return creativeControls;
        }
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    public static void onMouseRelease(ScreenMouseEvent.Release.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot hoverSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
            if (hoverSlot == null || InventoryEssentialsIgnores.shouldIgnoreScreen((Screen)screen2) || InventoryEssentialsIgnores.shouldIgnoreSlot(screen2, hoverSlot)) {
                return;
            }
            if (hasDragClicked) {
                event.setCanceled(true);
                hasDragClicked = false;
            }
        }
    }

    public static void onMouseDrag(ScreenMouseEvent.Drag.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            ItemStack carriedStack;
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot hoverSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
            if (hoverSlot == null || InventoryEssentialsIgnores.shouldIgnoreScreen((Screen)screen2) || InventoryEssentialsIgnores.shouldIgnoreSlot(screen2, hoverSlot)) {
                return;
            }
            if (ModKeyMappings.keyDragTransfer.isActiveAndDown() && (event.getButton() == 0 || event.getButton() == 1)) {
                if (hoverSlot.hasItem() && hoverSlot != lastDragHoverSlot) {
                    InventoryControls controls = InventoryEssentialsClient.getInventoryControls((Screen)screen2);
                    if (InventoryEssentialsConfig.getActive().enableShiftDrag) {
                        controls.dragTransfer(screen2, hoverSlot);
                    }
                    lastDragHoverSlot = hoverSlot;
                }
                return;
            }
            if (InventoryEssentialsConfig.getActive().enableBundleDrag && (carriedStack = screen2.getMenu().getCarried()).is(ItemTags.BUNDLES)) {
                if (hoverSlot != lastDragHoverSlot) {
                    if (event.getButton() == 0 && hoverSlot.hasItem() || event.getButton() == 1 && !hoverSlot.hasItem()) {
                        InventoryControls controls = InventoryEssentialsClient.getInventoryControls((Screen)screen2);
                        controls.dragClick(screen2, hoverSlot, event.getButton());
                        hasDragClicked = true;
                        ((AbstractContainerScreenAccessor)screen2).setIsQuickCrafting(false);
                    }
                    lastDragHoverSlot = hoverSlot;
                }
                event.setCanceled(true);
                return;
            }
            lastDragHoverSlot = null;
        } else {
            lastDragHoverSlot = null;
        }
    }
}

