/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.data;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.inventoryessentials.InventoryEssentialsIgnores;
import net.blay09.mods.inventoryessentials.data.IgnoredData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModFileJsonCompatLoader {
    private static final Logger logger = LoggerFactory.getLogger(ModFileJsonCompatLoader.class);
    private static final Gson gson = new Gson();

    public static void load() {
        Map modPaths = Balm.lookupAllModPaths((String)"inventoryessentials/ignores");
        modPaths.forEach((key, value) -> {
            try (Stream<Path> walker = Files.walk(value, new FileVisitOption[0]);){
                walker.forEach(file -> {
                    if (file.toString().endsWith(".json")) {
                        try (BufferedReader reader = Files.newBufferedReader(file);){
                            IgnoredData ignoredData = (IgnoredData)gson.fromJson((Reader)reader, IgnoredData.class);
                            if (ignoredData != null) {
                                InventoryEssentialsIgnores.addIgnoredData(ignoredData);
                            }
                        }
                        catch (IOException e) {
                            logger.error("Failed to load InventoryEssentials file {}", file, (Object)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                logger.error("Failed to load InventoryEssentials files from mod {}", key, (Object)e);
            }
        });
    }
}

