/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.blay09.mods.inventoryessentials.client.ClientInventorySorting;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_5151;
import net.minecraft.class_636;
import net.minecraft.class_746;

public class ClientOnlyInventoryControls
implements InventoryControls {
    @Override
    public boolean singleTransfer(class_465<?> screen, class_1735 clickedSlot) {
        class_1703 menu = screen.method_17577();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (!clickedSlot.method_7674((class_1657)player)) {
            return false;
        }
        class_1799 targetStack = clickedSlot.method_7677().method_7972();
        if (targetStack.method_7947() == 1) {
            this.slotClick(menu, clickedSlot, 0, class_1713.field_7794);
            return true;
        }
        class_1735 fallbackSlot = null;
        for (class_1735 slot : menu.field_7761) {
            class_1799 stack = slot.method_7677();
            if (!this.isValidTargetSlot(slot) || slot == clickedSlot || !slot.method_7680(targetStack) || InventoryUtils.isSameInventory(clickedSlot, slot) || stack.method_7947() >= Math.min(slot.method_7675(), slot.method_7676(stack))) continue;
            if (class_1799.method_31577((class_1799)targetStack, (class_1799)stack)) {
                this.slotClick(menu, clickedSlot, 1, class_1713.field_7790);
                this.slotClick(menu, slot, 1, class_1713.field_7790);
                this.slotClick(menu, clickedSlot, 0, class_1713.field_7790);
                return true;
            }
            if (slot.method_7681() || fallbackSlot != null) continue;
            fallbackSlot = slot;
        }
        if (fallbackSlot != null) {
            this.slotClick(menu, clickedSlot, 1, class_1713.field_7790);
            this.slotClick(menu, fallbackSlot, 1, class_1713.field_7790);
            this.slotClick(menu, clickedSlot, 0, class_1713.field_7790);
            return true;
        }
        return false;
    }

    @Override
    public boolean bulkTransferByType(class_465<?> screen, class_1735 clickedSlot) {
        class_1799 clickedStackCopy = clickedSlot.method_7677().method_7972();
        clickedStackCopy.method_7974(0);
        class_1703 menu = screen.method_17577();
        ArrayList<class_1735> transferSlots = new ArrayList<class_1735>();
        transferSlots.add(clickedSlot);
        for (class_1735 slot : menu.field_7761) {
            if (slot == clickedSlot || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot)) continue;
            class_1799 slotStackCopy = slot.method_7677().method_7972();
            slotStackCopy.method_7974(0);
            if (!class_1799.method_31577((class_1799)clickedStackCopy, (class_1799)slotStackCopy)) continue;
            transferSlots.add(slot);
        }
        for (class_1735 transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 0, class_1713.field_7794);
        }
        return true;
    }

    @Override
    public boolean bulkTransferSingle(class_465<?> screen, class_1735 clickedSlot) {
        class_5151 equipable;
        class_1792 class_17922;
        if (!clickedSlot.method_7681() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_1703 menu = screen.method_17577();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.field_7871 instanceof class_1661)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
        }
        boolean clickedAnArmorItem = (class_17922 = clickedSlot.method_7677().method_7909()) instanceof class_5151 && (equipable = (class_5151)class_17922).method_7685().method_46643();
        boolean isInsideInventory = menu instanceof class_1723;
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<class_1735> emptySlots = new ArrayDeque<class_1735>();
            ArrayList<class_1735> nonEmptySlots = new ArrayList<class_1735>();
            for (class_1735 slot : menu.field_7761) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.field_7871 instanceof class_1661) || !this.isValidTargetSlot(slot)) continue;
                if (slot.method_7681()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (class_1661.method_7380((int)slot.method_34266())) continue;
                emptySlots.add(slot);
            }
            for (class_1735 slot : menu.field_7761) {
                if (!slot.method_7674((class_1657)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.quickTransferSingle(menu, emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else if (clickedAnArmorItem && isInsideInventory) {
            if (!InventoryEssentialsConfig.getActive().bulkTransferArmorSets) {
                return false;
            }
            if (!menu.method_34255().method_7960()) {
                return false;
            }
            if (clickedSlot.field_7874 >= 5 && clickedSlot.field_7874 < 9) {
                for (int i = 5; i < 9; ++i) {
                    this.slotClick(menu, i, 0, class_1713.field_7794);
                }
                return true;
            }
            Map<class_1304, class_1735> armorSlots = InventoryUtils.findMatchingArmorSetSlots(menu, clickedSlot);
            List<class_1304> equipmentSlots = List.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166);
            for (int i = 5; i < 9; ++i) {
                class_1304 equipmentSlot = equipmentSlots.get(i - 5);
                class_1735 swapSlot = armorSlots.get(equipmentSlot);
                if (swapSlot == null) continue;
                this.slotClick(menu, i, 0, class_1713.field_7790);
                this.slotClick(menu, swapSlot, 0, class_1713.field_7790);
                this.slotClick(menu, i, 0, class_1713.field_7790);
            }
            movedAny = true;
        } else {
            for (class_1735 slot : menu.field_7761) {
                if (!slot.method_7674((class_1657)player) || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.singleTransfer(screen, slot);
                movedAny = true;
            }
        }
        return movedAny;
    }

    @Override
    public boolean bulkTransferAll(class_465<?> screen, class_1735 clickedSlot) {
        class_5151 equipable;
        class_1792 class_17922;
        if (!clickedSlot.method_7681() && !InventoryEssentialsConfig.getActive().allowBulkTransferAllOnEmptySlot) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_1703 menu = screen.method_17577();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.field_7871 instanceof class_1661)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
        }
        boolean clickedAnArmorItem = (class_17922 = clickedSlot.method_7677().method_7909()) instanceof class_5151 && (equipable = (class_5151)class_17922).method_7685().method_46643();
        boolean isInsideInventory = menu instanceof class_1723;
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<class_1735> emptySlots = new ArrayDeque<class_1735>();
            ArrayList<class_1735> nonEmptySlots = new ArrayList<class_1735>();
            for (class_1735 slot : menu.field_7761) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.field_7871 instanceof class_1661) || !this.isValidTargetSlot(slot)) continue;
                if (slot.method_7681()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (class_1661.method_7380((int)slot.method_34266())) continue;
                emptySlots.add(slot);
            }
            for (class_1735 slot : menu.field_7761) {
                if (!slot.method_7674((class_1657)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.quickTransferStack(menu, emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else if (clickedAnArmorItem && isInsideInventory) {
            if (!InventoryEssentialsConfig.getActive().bulkTransferArmorSets) {
                return false;
            }
            if (!menu.method_34255().method_7960()) {
                return false;
            }
            if (clickedSlot.field_7874 >= 5 && clickedSlot.field_7874 < 9) {
                for (int i = 5; i < 9; ++i) {
                    this.slotClick(menu, i, 0, class_1713.field_7794);
                }
                return true;
            }
            Map<class_1304, class_1735> armorSlots = InventoryUtils.findMatchingArmorSetSlots(menu, clickedSlot);
            List<class_1304> equipmentSlots = List.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166);
            for (int i = 5; i < 9; ++i) {
                class_1304 equipmentSlot = equipmentSlots.get(i - 5);
                class_1735 swapSlot = armorSlots.get(equipmentSlot);
                if (swapSlot == null) continue;
                this.slotClick(menu, i, 0, class_1713.field_7790);
                this.slotClick(menu, swapSlot, 0, class_1713.field_7790);
                this.slotClick(menu, i, 0, class_1713.field_7790);
            }
            movedAny = true;
        } else {
            for (class_1735 slot : menu.field_7761) {
                if (!slot.method_7674((class_1657)player) || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.slotClick(menu, slot, 0, class_1713.field_7794);
                movedAny = true;
            }
        }
        return movedAny;
    }

    private boolean quickTransferStack(class_1703 menu, Deque<class_1735> emptySlots, List<class_1735> nonEmptySlots, class_1735 slot) {
        class_1799 targetStack = slot.method_7677().method_7972();
        if (targetStack.method_7960()) {
            return false;
        }
        this.slotClick(menu, slot, 0, class_1713.field_7790);
        for (class_1735 nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            class_1799 stack = nonEmptySlot.method_7677();
            if (!class_1799.method_31577((class_1799)targetStack, (class_1799)stack)) continue;
            boolean bl = hasSpaceLeft = stack.method_7947() < Math.min(nonEmptySlot.method_7675(), nonEmptySlot.method_7676(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(menu, nonEmptySlot, 0, class_1713.field_7790);
            class_1799 mouseItem = menu.method_34255();
            if (!mouseItem.method_7960()) continue;
            return true;
        }
        Iterator<class_1735> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            class_1799 mouseItem;
            class_1735 emptySlot = iterator.next();
            this.slotClick(menu, emptySlot, 0, class_1713.field_7790);
            if (emptySlot.method_7681()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = menu.method_34255()).method_7960()) continue;
            return true;
        }
        class_1799 mouseItem = menu.method_34255();
        if (!mouseItem.method_7960()) {
            this.slotClick(menu, slot, 0, class_1713.field_7790);
        }
        return false;
    }

    private boolean quickTransferSingle(class_1703 menu, Deque<class_1735> emptySlots, List<class_1735> nonEmptySlots, class_1735 slot) {
        class_1799 targetStack = slot.method_7677().method_7972();
        if (targetStack.method_7960()) {
            return false;
        }
        this.slotClick(menu, slot, 0, class_1713.field_7790);
        for (class_1735 nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            class_1799 stack = nonEmptySlot.method_7677();
            if (!class_1799.method_31577((class_1799)targetStack, (class_1799)stack)) continue;
            boolean bl = hasSpaceLeft = stack.method_7947() < Math.min(nonEmptySlot.method_7675(), nonEmptySlot.method_7676(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(menu, nonEmptySlot, 1, class_1713.field_7790);
            class_1799 mouseItem = menu.method_34255();
            if (mouseItem.method_7947() >= targetStack.method_7947()) continue;
            this.slotClick(menu, slot, 0, class_1713.field_7790);
            return true;
        }
        Iterator<class_1735> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            class_1799 mouseItem;
            class_1735 emptySlot = iterator.next();
            this.slotClick(menu, emptySlot, 1, class_1713.field_7790);
            if (emptySlot.method_7681()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if ((mouseItem = menu.method_34255()).method_7947() >= targetStack.method_7947()) continue;
            this.slotClick(menu, slot, 0, class_1713.field_7790);
            return true;
        }
        class_1799 mouseItem = menu.method_34255();
        if (!mouseItem.method_7960()) {
            this.slotClick(menu, slot, 0, class_1713.field_7790);
        }
        return false;
    }

    @Override
    public void dragTransfer(class_465<?> screen, class_1735 clickedSlot) {
        this.slotClick(screen.method_17577(), clickedSlot, 0, class_1713.field_7794);
    }

    @Override
    public boolean sort(class_465<?> screen, class_1735 baseSlot) {
        class_1703 menu = screen.method_17577();
        return ClientInventorySorting.sort(menu, baseSlot, this::slotClick);
    }

    protected void slotClick(class_1703 menu, class_1735 slot, int mouseButton, class_1713 clickType) {
        this.slotClick(menu, slot.field_7874, mouseButton, clickType);
    }

    protected void slotClick(class_1703 menu, int slotIndex, int mouseButton, class_1713 clickType) {
        class_746 player = class_310.method_1551().field_1724;
        class_636 gameMode = class_310.method_1551().field_1761;
        if (player != null && gameMode != null && (slotIndex >= 0 && slotIndex < menu.field_7761.size() || slotIndex == -999)) {
            gameMode.method_2906(menu.field_7763, slotIndex, mouseButton, clickType, (class_1657)player);
        }
    }

    @Override
    public boolean dropByType(class_465<?> screen, class_1735 hoverSlot) {
        class_1799 targetStack = hoverSlot.method_7677().method_7972();
        class_1703 menu = screen.method_17577();
        ArrayList<class_1735> transferSlots = new ArrayList<class_1735>();
        transferSlots.add(hoverSlot);
        for (class_1735 slot : menu.field_7761) {
            class_1799 stack;
            if (slot == hoverSlot || !this.isValidTargetSlot(slot) || !InventoryUtils.isSameInventory(slot, hoverSlot) || !class_1799.method_31577((class_1799)targetStack, (class_1799)(stack = slot.method_7677()))) continue;
            transferSlots.add(slot);
        }
        for (class_1735 transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, class_1713.field_7795);
        }
        return true;
    }

    @Override
    public boolean dropByType(class_465<?> screen, class_1799 targetStack) {
        if (targetStack.method_7960()) {
            return false;
        }
        class_1703 menu = screen.method_17577();
        ArrayList<class_1735> transferSlots = new ArrayList<class_1735>();
        for (class_1735 slot : menu.field_7761) {
            class_1799 stack = slot.method_7677();
            if (!class_1799.method_31577((class_1799)targetStack, (class_1799)stack) || !this.isValidTargetSlot(slot)) continue;
            transferSlots.add(slot);
        }
        this.slotClick(menu, -999, 0, class_1713.field_7790);
        for (class_1735 transferSlot : transferSlots) {
            this.slotClick(menu, transferSlot, 1, class_1713.field_7795);
        }
        return true;
    }

    protected boolean isValidTargetSlot(class_1735 slot) {
        return true;
    }
}

