/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1736;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_746;

public class ClientInventorySorting {
    private static final Comparator<class_1799> defaultComparator = Comparator.comparing(itemStack -> itemStack.method_7964().getString(), String.CASE_INSENSITIVE_ORDER).thenComparing(Comparator.comparingInt(class_1799::method_7947).reversed()).thenComparing(itemStack -> itemStack.method_7942() ? 0 : 1).thenComparingInt(class_1799::method_7919).thenComparing(itemStack -> Objects.toString(itemStack.method_57353(), ""));

    public static boolean sort(class_1703 menu, class_1735 baseSlot, SlotClicker clicker) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        ArrayList<class_1735> slotsToSort = new ArrayList<class_1735>();
        for (class_1735 slot : menu.field_7761) {
            if (!ClientInventorySorting.isSortableSlot(slot) || !InventoryUtils.isSameInventory(baseSlot, slot, true)) continue;
            slotsToSort.add(slot);
        }
        if (slotsToSort.isEmpty()) {
            return false;
        }
        ClientInventorySorting.consolidateStacks(menu, slotsToSort, clicker);
        List<class_1799> goalSorting = slotsToSort.stream().map(class_1735::method_7677).map(class_1799::method_7972).filter(stack -> !stack.method_7960()).sorted(defaultComparator).toList();
        for (int i = 0; i < goalSorting.size(); ++i) {
            class_1799 currentStack;
            class_1799 goalStack = goalSorting.get(i);
            if (class_1799.method_31577((class_1799)goalStack, (class_1799)(currentStack = slotsToSort.get(i).method_7677())) && goalStack.method_7947() == currentStack.method_7947()) continue;
            int foundSwapIndex = -1;
            for (int j = i + 1; j < slotsToSort.size(); ++j) {
                class_1799 candidateStack = slotsToSort.get(j).method_7677();
                if (!class_1799.method_31577((class_1799)goalStack, (class_1799)candidateStack) || goalStack.method_7947() != candidateStack.method_7947()) continue;
                foundSwapIndex = j;
                break;
            }
            if (foundSwapIndex == -1) continue;
            ClientInventorySorting.swapSlots(menu, slotsToSort, i, foundSwapIndex, clicker);
        }
        return true;
    }

    private static void swapSlots(class_1703 menu, List<class_1735> slots, int firstIndex, int secondIndex, SlotClicker clicker) {
        if (firstIndex != secondIndex) {
            class_1735 firstSlot = slots.get(firstIndex);
            class_1735 secondSlot = slots.get(secondIndex);
            class_1799 firstStack = firstSlot.method_7677();
            class_1799 secondStack = secondSlot.method_7677();
            if (!firstSlot.method_7681() || !secondSlot.method_7681()) {
                class_1735 fromSlot = firstSlot.method_7681() ? firstSlot : secondSlot;
                class_1735 toSlot = firstSlot.method_7681() ? secondSlot : firstSlot;
                clicker.click(menu, fromSlot, 0, class_1713.field_7790);
                clicker.click(menu, toSlot, 0, class_1713.field_7790);
                return;
            }
            if (firstStack.method_31573(class_3489.field_54294) || secondStack.method_31573(class_3489.field_54294)) {
                class_1735 emptyBufferSlot = null;
                for (class_1735 candidate : slots) {
                    if (candidate.method_7681()) continue;
                    emptyBufferSlot = candidate;
                    break;
                }
                if (emptyBufferSlot != null) {
                    clicker.click(menu, firstSlot, 0, class_1713.field_7790);
                    clicker.click(menu, emptyBufferSlot, 0, class_1713.field_7790);
                    clicker.click(menu, secondSlot, 0, class_1713.field_7790);
                    clicker.click(menu, firstSlot, 0, class_1713.field_7790);
                    clicker.click(menu, emptyBufferSlot, 0, class_1713.field_7790);
                    clicker.click(menu, secondSlot, 0, class_1713.field_7790);
                }
            } else {
                clicker.click(menu, firstSlot, 0, class_1713.field_7790);
                clicker.click(menu, secondSlot, 0, class_1713.field_7790);
                clicker.click(menu, firstSlot, 0, class_1713.field_7790);
            }
        }
    }

    private static void consolidateStacks(class_1703 menu, List<class_1735> slots, SlotClicker clicker) {
        block0: for (int i = 0; i < slots.size(); ++i) {
            class_1735 thisSlot = slots.get(i);
            if (!thisSlot.method_7681()) continue;
            class_1799 thisStack = thisSlot.method_7677();
            for (int j = i + 1; j < slots.size(); ++j) {
                class_1735 otherSlot = slots.get(j);
                class_1799 otherStack = otherSlot.method_7677();
                if (thisStack.method_31573(class_3489.field_54294) || otherStack.method_31573(class_3489.field_54294) || otherStack.method_7960() || !class_1799.method_31577((class_1799)thisStack, (class_1799)otherStack)) continue;
                clicker.click(menu, otherSlot, 0, class_1713.field_7790);
                clicker.click(menu, thisSlot, 0, class_1713.field_7790);
                if (!menu.method_34255().method_7960()) {
                    clicker.click(menu, otherSlot, 0, class_1713.field_7790);
                }
                class_1799 newThisStack = thisSlot.method_7677();
                int newThisStackFull = newThisStack.method_7914();
                if (newThisStack.method_7947() >= newThisStackFull) continue block0;
            }
        }
    }

    private static boolean isSortableSlot(class_1735 slot) {
        int containerSlot;
        if (slot.field_7871 instanceof class_1661 && ((containerSlot = slot.method_34266()) < 9 || containerSlot >= 36)) {
            return false;
        }
        return slot.getClass() == class_1735.class || slot.getClass() == class_1736.class;
    }

    @FunctionalInterface
    public static interface SlotClicker {
        public void click(class_1703 var1, class_1735 var2, int var3, class_1713 var4);
    }
}

