/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.data;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.inventoryessentials.InventoryEssentialsIgnores;
import net.blay09.mods.inventoryessentials.data.IgnoredData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModFileJsonCompatLoader {
    private static final Logger logger = LoggerFactory.getLogger(ModFileJsonCompatLoader.class);
    private static final Gson gson = new Gson();

    public static void load() {
        Balm.getLoadedPrimaryModIds().forEach(modId -> Balm.visitModResources((String)modId, (String)"inventoryessentials/ignores", resource -> {
            if (resource.extension().equals("json")) {
                try (BufferedReader reader = resource.bufferedReader();){
                    IgnoredData ignoredData = (IgnoredData)gson.fromJson((Reader)reader, IgnoredData.class);
                    if (ignoredData != null) {
                        InventoryEssentialsIgnores.addIgnoredData(ignoredData);
                    }
                }
                catch (IOException e) {
                    logger.error("Failed to load InventoryEssentials file {}", (Object)resource.name(), (Object)e);
                }
            }
        }));
    }
}

