/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.blay09.mods.inventoryessentials.tags.ModItemTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ClientInventorySorting {
    private static final Comparator<ItemStack> defaultComparator = Comparator.comparing(itemStack -> itemStack.getHoverName().getString(), String.CASE_INSENSITIVE_ORDER).thenComparing(Comparator.comparingInt(ItemStack::getCount).reversed()).thenComparing(itemStack -> itemStack.isEnchanted() ? 0 : 1).thenComparingInt(ItemStack::getDamageValue).thenComparing(itemStack -> Objects.toString(itemStack.getComponents(), ""));

    public static boolean sort(AbstractContainerMenu menu, Slot baseSlot, SlotClicker clicker) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        ArrayList<Slot> slotsToSort = new ArrayList<Slot>();
        for (Slot slot : menu.slots) {
            if (!ClientInventorySorting.isSortableSlot(slot) || !InventoryUtils.isSameInventory(baseSlot, slot, true)) continue;
            slotsToSort.add(slot);
        }
        if (slotsToSort.isEmpty()) {
            return false;
        }
        ClientInventorySorting.consolidateStacks(menu, slotsToSort, clicker);
        List<ItemStack> goalSorting = slotsToSort.stream().map(Slot::getItem).map(ItemStack::copy).filter(stack -> !stack.isEmpty()).sorted(defaultComparator).toList();
        for (int i = 0; i < goalSorting.size(); ++i) {
            ItemStack currentStack;
            ItemStack goalStack = goalSorting.get(i);
            if (ItemStack.isSameItemSameComponents((ItemStack)goalStack, (ItemStack)(currentStack = slotsToSort.get(i).getItem())) && goalStack.getCount() == currentStack.getCount()) continue;
            int foundSwapIndex = -1;
            for (int j = i + 1; j < slotsToSort.size(); ++j) {
                ItemStack candidateStack = slotsToSort.get(j).getItem();
                if (!ItemStack.isSameItemSameComponents((ItemStack)goalStack, (ItemStack)candidateStack) || goalStack.getCount() != candidateStack.getCount()) continue;
                foundSwapIndex = j;
                break;
            }
            if (foundSwapIndex == -1) continue;
            ClientInventorySorting.swapSlots(menu, slotsToSort, i, foundSwapIndex, clicker);
        }
        return true;
    }

    private static void swapSlots(AbstractContainerMenu menu, List<Slot> slots, int firstIndex, int secondIndex, SlotClicker clicker) {
        if (firstIndex != secondIndex) {
            Slot firstSlot = slots.get(firstIndex);
            Slot secondSlot = slots.get(secondIndex);
            ItemStack firstStack = firstSlot.getItem();
            ItemStack secondStack = secondSlot.getItem();
            if (!firstSlot.hasItem() || !secondSlot.hasItem()) {
                Slot fromSlot = firstSlot.hasItem() ? firstSlot : secondSlot;
                Slot toSlot = firstSlot.hasItem() ? secondSlot : firstSlot;
                clicker.click(menu, fromSlot, 0, ClickType.PICKUP);
                clicker.click(menu, toSlot, 0, ClickType.PICKUP);
                return;
            }
            if (firstStack.is(ModItemTags.BUNDLES) || secondStack.is(ModItemTags.BUNDLES)) {
                Slot emptyBufferSlot = null;
                for (Slot candidate : slots) {
                    if (candidate.hasItem()) continue;
                    emptyBufferSlot = candidate;
                    break;
                }
                if (emptyBufferSlot != null) {
                    clicker.click(menu, firstSlot, 0, ClickType.PICKUP);
                    clicker.click(menu, emptyBufferSlot, 0, ClickType.PICKUP);
                    clicker.click(menu, secondSlot, 0, ClickType.PICKUP);
                    clicker.click(menu, firstSlot, 0, ClickType.PICKUP);
                    clicker.click(menu, emptyBufferSlot, 0, ClickType.PICKUP);
                    clicker.click(menu, secondSlot, 0, ClickType.PICKUP);
                }
            } else {
                clicker.click(menu, firstSlot, 0, ClickType.PICKUP);
                clicker.click(menu, secondSlot, 0, ClickType.PICKUP);
                clicker.click(menu, firstSlot, 0, ClickType.PICKUP);
            }
        }
    }

    private static void consolidateStacks(AbstractContainerMenu menu, List<Slot> slots, SlotClicker clicker) {
        block0: for (int i = 0; i < slots.size(); ++i) {
            Slot thisSlot = slots.get(i);
            if (!thisSlot.hasItem()) continue;
            ItemStack thisStack = thisSlot.getItem();
            for (int j = i + 1; j < slots.size(); ++j) {
                Slot otherSlot = slots.get(j);
                ItemStack otherStack = otherSlot.getItem();
                if (thisStack.is(ModItemTags.BUNDLES) || otherStack.is(ModItemTags.BUNDLES) || otherStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)thisStack, (ItemStack)otherStack)) continue;
                clicker.click(menu, otherSlot, 0, ClickType.PICKUP);
                clicker.click(menu, thisSlot, 0, ClickType.PICKUP);
                if (!menu.getCarried().isEmpty()) {
                    clicker.click(menu, otherSlot, 0, ClickType.PICKUP);
                }
                ItemStack newThisStack = thisSlot.getItem();
                int newThisStackFull = newThisStack.getMaxStackSize();
                if (newThisStack.getCount() >= newThisStackFull) continue block0;
            }
        }
    }

    private static boolean isSortableSlot(Slot slot) {
        int containerSlot;
        if (slot.container instanceof Inventory && ((containerSlot = slot.getContainerSlot()) < 9 || containerSlot >= 36)) {
            return false;
        }
        return slot.getClass() == Slot.class;
    }

    @FunctionalInterface
    public static interface SlotClicker {
        public void click(AbstractContainerMenu var1, Slot var2, int var3, ClickType var4);
    }
}

