/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryEssentialsIgnores;
import net.blay09.mods.inventoryessentials.client.InventoryEssentialsClient;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.kuma.api.InputBinding;
import net.blay09.mods.kuma.api.KeyConflictContext;
import net.blay09.mods.kuma.api.KeyModifier;
import net.blay09.mods.kuma.api.KeyModifiers;
import net.blay09.mods.kuma.api.Kuma;
import net.blay09.mods.kuma.api.ManagedKeyMapping;
import net.blay09.mods.kuma.api.ScreenInputEvent;
import net.minecraft.class_1735;
import net.minecraft.class_2960;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class ModKeyMappings {
    public static ManagedKeyMapping keySingleTransfer;
    public static ManagedKeyMapping keyBulkTransfer;
    public static ManagedKeyMapping keyBulkTransferSingle;
    public static ManagedKeyMapping keyBulkTransferAll;
    public static ManagedKeyMapping keyBulkDrop;
    public static ManagedKeyMapping keyScreenBulkDrop;
    public static ManagedKeyMapping keyDragTransfer;
    public static ManagedKeyMapping keySortInventory;

    public static void initialize() {
        keySingleTransfer = Kuma.createKeyMapping((class_2960)new class_2960("inventoryessentials", "single_transfer")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableSingleTransfer, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((class_437)screen).singleTransfer((class_465<?>)screen, (class_1735)slot))).build();
        keyBulkTransfer = Kuma.createKeyMapping((class_2960)new class_2960("inventoryessentials", "bulk_transfer")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT, KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransfer, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((class_437)screen).bulkTransferByType((class_465<?>)screen, (class_1735)slot))).build();
        keyBulkTransferSingle = Kuma.createKeyMapping((class_2960)new class_2960("inventoryessentials", "bulk_transfer_single")).withDefault(InputBinding.mouse((int)1, (KeyModifiers)KeyModifiers.ofCustom((class_3675.class_306[])new class_3675.class_306[]{class_3675.method_15985((int)32, (int)-1)}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransferSingle, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((class_437)screen).bulkTransferSingle((class_465<?>)screen, (class_1735)slot))).build();
        keyBulkTransferAll = Kuma.createKeyMapping((class_2960)new class_2960("inventoryessentials", "bulk_transfer_all")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.ofCustom((class_3675.class_306[])new class_3675.class_306[]{class_3675.method_15985((int)32, (int)-1)}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransferAll, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((class_437)screen).bulkTransferAll((class_465<?>)screen, (class_1735)slot))).build();
        keyBulkDrop = Kuma.createKeyMapping((class_2960)new class_2960("inventoryessentials", "bulk_drop")).withDefault(InputBinding.key((int)81, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT, KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkDrop, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((class_437)screen).dropByType((class_465<?>)screen, (class_1735)slot))).build();
        keyScreenBulkDrop = Kuma.createKeyMapping((class_2960)new class_2960("inventoryessentials", "screen_bulk_drop")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT}))).handleScreenInput(event -> {
            if (!InventoryEssentialsConfig.getActive().enableBulkDrop) {
                return false;
            }
            if (InventoryEssentialsIgnores.shouldIgnoreScreen(event.screen())) {
                return false;
            }
            class_437 patt4530$temp = event.screen();
            if (!(patt4530$temp instanceof class_465)) {
                return false;
            }
            class_465 containerScreen = (class_465)patt4530$temp;
            AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)containerScreen;
            int button = keyScreenBulkDrop.getBinding().key().method_1444();
            boolean clickedOutside = accessor.callHasClickedOutside(event.mouseX(), event.mouseY(), accessor.getLeftPos(), accessor.getTopPos(), button);
            return clickedOutside && InventoryEssentialsClient.getInventoryControls((class_437)containerScreen).dropByType(containerScreen, containerScreen.method_17577().method_34255());
        }).build();
        keyDragTransfer = Kuma.createKeyMapping((class_2960)new class_2960("inventoryessentials", "drag_transfer")).withDefault(InputBinding.key((int)340)).withContext(KeyConflictContext.SCREEN).forceVirtual().build();
        keySortInventory = Kuma.createKeyMapping((class_2960)new class_2960("inventoryessentials", "sort_inventory")).withDefault(InputBinding.mouse((int)2)).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableMiddleClickSort, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((class_437)screen).sort((class_465<?>)screen, (class_1735)slot))).build();
    }

    private static boolean handleSlotInput(ScreenInputEvent event, Supplier<Boolean> predicate, BiFunction<class_465<?>, class_1735, Boolean> handler) {
        if (!predicate.get().booleanValue()) {
            return false;
        }
        if (InventoryEssentialsIgnores.shouldIgnoreScreen(event.screen())) {
            return false;
        }
        class_437 class_4372 = event.screen();
        if (!(class_4372 instanceof class_465)) {
            return false;
        }
        class_465 containerScreen = (class_465)class_4372;
        class_1735 hoverSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
        if (InventoryEssentialsIgnores.shouldIgnoreSlot(containerScreen, hoverSlot)) {
            return false;
        }
        return handler.apply(containerScreen, hoverSlot);
    }
}

