/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.blay09.mods.inventoryessentials.PlatformBindings;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class InventoryUtils {
    public static boolean isSameInventory(Slot targetSlot, Slot slot) {
        return InventoryUtils.isSameInventory(targetSlot, slot, false);
    }

    public static boolean isSameInventory(Slot targetSlot, Slot slot, boolean treatHotBarAsSeparate) {
        boolean isHotBar;
        boolean isTargetPlayerInventory = targetSlot.container instanceof Inventory;
        boolean isTargetHotBar = isTargetPlayerInventory && Inventory.isHotbarSlot((int)targetSlot.getContainerSlot());
        boolean isPlayerInventory = slot.container instanceof Inventory;
        boolean bl = isHotBar = isPlayerInventory && Inventory.isHotbarSlot((int)slot.getContainerSlot());
        if (isTargetPlayerInventory && isPlayerInventory && treatHotBarAsSeparate) {
            return isHotBar == isTargetHotBar;
        }
        return PlatformBindings.INSTANCE.isSameInventory(targetSlot, slot);
    }

    public static boolean containerContainsPlayerInventory(AbstractContainerMenu menu) {
        for (Slot slot : menu.slots) {
            if (!(slot.container instanceof Inventory) || slot.getContainerSlot() < 9 || slot.getContainerSlot() >= 37) continue;
            return true;
        }
        return false;
    }

    public static Map<EquipmentSlot, Slot> findMatchingArmorSetSlots(AbstractContainerMenu menu, Slot baseSlot) {
        HashMap<EquipmentSlot, Slot> result = new HashMap<EquipmentSlot, Slot>();
        List<EquipmentSlot> equipmentSlots = Arrays.stream(EquipmentSlot.values()).filter(EquipmentSlot::isArmor).toList();
        ItemStack baseItem = baseSlot.getItem();
        Equippable baseEquippable = (Equippable)baseItem.get(DataComponents.EQUIPPABLE);
        if (baseEquippable != null && baseEquippable.slot().isArmor()) {
            result.put(baseEquippable.slot(), baseSlot);
        }
        for (Slot slot : menu.slots) {
            if (menu instanceof InventoryMenu && slot.index >= 5 && slot.index < 9) continue;
            ItemStack slotStack = slot.getItem();
            Equippable slotEquippable = (Equippable)slotStack.get(DataComponents.EQUIPPABLE);
            if (slotEquippable != null && slotEquippable.slot().isArmor() && InventoryUtils.isMatchingArmorSet(baseItem, slotStack) && !result.containsKey(slotEquippable.slot())) {
                result.put(slotEquippable.slot(), slot);
            }
            if (result.size() < equipmentSlots.size()) continue;
            break;
        }
        return result;
    }

    private static boolean isMatchingArmorSet(ItemStack baseItem, ItemStack otherItem) {
        Equippable baseEquippable = (Equippable)baseItem.get(DataComponents.EQUIPPABLE);
        Equippable otherEquippable = (Equippable)otherItem.get(DataComponents.EQUIPPABLE);
        if (baseEquippable != null && otherEquippable != null) {
            return Objects.equals(baseEquippable.assetId().orElse(null), otherEquippable.assetId().orElse(null));
        }
        return false;
    }
}

