/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.blay09.mods.inventoryessentials.ServerInventoryTransfers;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5151;
import net.minecraft.class_8710;

public class BulkTransferSingleMessage
implements class_8710 {
    public static final class_8710.class_9154<BulkTransferSingleMessage> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"inventoryessentials", (String)"bulk_transfer_single"));
    private final int slotNumber;

    public BulkTransferSingleMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static BulkTransferSingleMessage decode(class_2540 buf) {
        byte slotNumber = buf.readByte();
        return new BulkTransferSingleMessage(slotNumber);
    }

    public static void encode(class_2540 buf, BulkTransferSingleMessage message) {
        buf.method_52997(message.slotNumber);
    }

    public static void handle(class_3222 player, BulkTransferSingleMessage message) {
        block13: {
            class_5151 equipable;
            Object object;
            class_1703 menu = player.field_7512;
            if (menu == null || message.slotNumber < 0 || message.slotNumber >= menu.field_7761.size()) break block13;
            class_1735 clickedSlot = (class_1735)menu.field_7761.get(message.slotNumber);
            boolean isProbablyMovingToPlayerInventory = false;
            if (!(clickedSlot.field_7871 instanceof class_1661)) {
                isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
            }
            boolean clickedAnArmorItem = (object = clickedSlot.method_7677().method_7909()) instanceof class_5151 && (equipable = (class_5151)object).method_7685().method_46643();
            boolean isInsideInventory = menu instanceof class_1723;
            if (isProbablyMovingToPlayerInventory) {
                ArrayDeque<class_1735> emptySlots = new ArrayDeque<class_1735>();
                ArrayList<class_1735> nonEmptySlots = new ArrayList<class_1735>();
                for (class_1735 slot : menu.field_7761) {
                    if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.field_7871 instanceof class_1661)) continue;
                    if (slot.method_7681()) {
                        nonEmptySlots.add(slot);
                        continue;
                    }
                    if (class_1661.method_7380((int)slot.method_34266())) continue;
                    emptySlots.add(slot);
                }
                for (class_1735 slot : menu.field_7761) {
                    if (!slot.method_7674((class_1657)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                    BulkTransferSingleMessage.quickTransferSingle((class_1657)player, menu, emptySlots, nonEmptySlots, slot);
                }
            } else if (clickedAnArmorItem && isInsideInventory) {
                if (!InventoryEssentialsConfig.getActive().bulkTransferArmorSets) {
                    return;
                }
                if (clickedSlot.field_7874 >= 5 && clickedSlot.field_7874 < 9) {
                    for (int i = 5; i < 9; ++i) {
                        menu.method_7593(i, 0, class_1713.field_7794, (class_1657)player);
                    }
                    return;
                }
                Map<class_1304, class_1735> armorSlots = InventoryUtils.findMatchingArmorSetSlots(menu, clickedSlot);
                List<class_1304> equipmentSlots = List.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166);
                for (int i = 5; i < 9; ++i) {
                    class_1304 equipmentSlot = equipmentSlots.get(i - 5);
                    class_1735 swapSlot = armorSlots.get(equipmentSlot);
                    if (swapSlot == null) continue;
                    menu.method_7593(i, 0, class_1713.field_7790, (class_1657)player);
                    menu.method_7593(swapSlot.field_7874, 0, class_1713.field_7790, (class_1657)player);
                    menu.method_7593(i, 0, class_1713.field_7790, (class_1657)player);
                }
            } else {
                for (class_1735 slot : menu.field_7761) {
                    if (!slot.method_7674((class_1657)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                    ServerInventoryTransfers.singleTransfer(player, menu, slot);
                }
            }
        }
    }

    private static boolean quickTransferSingle(class_1657 player, class_1703 menu, Deque<class_1735> emptySlots, List<class_1735> nonEmptySlots, class_1735 slot) {
        class_1799 targetStack = slot.method_7677().method_7972();
        if (targetStack.method_7960()) {
            return false;
        }
        menu.method_7593(slot.field_7874, 0, class_1713.field_7790, player);
        for (class_1735 nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            class_1799 stack = nonEmptySlot.method_7677();
            if (!class_1799.method_31577((class_1799)targetStack, (class_1799)stack)) continue;
            boolean bl = hasSpaceLeft = stack.method_7947() < Math.min(nonEmptySlot.method_7675(), nonEmptySlot.method_7676(stack));
            if (!hasSpaceLeft) continue;
            menu.method_7593(nonEmptySlot.field_7874, 1, class_1713.field_7790, player);
            class_1799 mouseItem = menu.method_34255();
            if (mouseItem.method_7947() >= targetStack.method_7947()) continue;
            menu.method_7593(slot.field_7874, 0, class_1713.field_7790, player);
            return true;
        }
        Iterator<class_1735> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            class_1799 mouseItem;
            class_1735 emptySlot = iterator.next();
            menu.method_7593(emptySlot.field_7874, 1, class_1713.field_7790, player);
            if (emptySlot.method_7681()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if ((mouseItem = menu.method_34255()).method_7947() >= targetStack.method_7947()) continue;
            menu.method_7593(slot.field_7874, 0, class_1713.field_7790, player);
            return true;
        }
        class_1799 mouseItem = menu.method_34255();
        if (!mouseItem.method_7960()) {
            menu.method_7593(slot.field_7874, 0, class_1713.field_7790, player);
        }
        return false;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

