/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.event;

import appeng.api.util.AEColor;
import com.enderio.base.api.EnderIO;
import com.enderio.conduits.api.Conduit;
import com.enderio.conduits.common.conduit.type.energy.EnergyConduit;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduit;
import com.enderio.modconduits.common.modules.appeng.MEConduit;
import com.enderio.modconduits.common.modules.mekanism.chemical.ChemicalConduit;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;

public class ConduitRegistryEvent
implements KubeEvent {
    @HideFromJS
    public static final Map<ResourceLocation, JsonElement> CUSTOM_CONDUITS = new HashMap<ResourceLocation, JsonElement>();

    public void registerEnergyConduit(String id, Component name, int transferRate) {
        CustomConduit.of(id, name).bindInstance((n, tex) -> new EnergyConduit(tex, n, transferRate));
    }

    public void registerFluidConduit(String id, Component name, int transferRate, boolean multiFluid, boolean supportPriority) {
        CustomConduit.of(id, name).bindInstance((n, tex) -> new FluidConduit(tex, n, transferRate, multiFluid, supportPriority));
    }

    public void registerChemicalConduit(String id, Component name, int transferRate, boolean multiChemical) {
        Preconditions.checkArgument((boolean)ModList.get().isLoaded("mekanism"), (Object)"mekanism must be loaded to use chemical conduits");
        CustomConduit.of(id, name).bindInstance((n, tex) -> new ChemicalConduit(tex, n, (long)transferRate, multiChemical));
    }

    public void registerMeConduit(String id, Component name, String color, boolean dense) {
        Preconditions.checkArgument((boolean)Ae2Integration.isLoaded(), (Object)"applied energistics 2 must be loaded to use me conduits");
        BiFunction<Component, ResourceLocation, Conduit<?, ?>> conduitFactory = Ae2Integration.createFactory(color, dense);
        CustomConduit.of(id, name).bindInstance(conduitFactory);
    }

    @HideFromJS
    public static void clear() {
        CUSTOM_CONDUITS.clear();
        CustomConduit.CONDUIT_IDS.clear();
    }

    private record CustomConduit(String id, Component name) {
        private static final Set<String> CONDUIT_IDS = new HashSet<String>();

        private static CustomConduit of(String id, Component name) {
            Preconditions.checkArgument((!id.contains(":") ? 1 : 0) != 0, (Object)"id must not contain a colon (:)");
            Preconditions.checkArgument((!id.contains(" ") ? 1 : 0) != 0, (Object)"id must not contain a space");
            Preconditions.checkArgument((!CONDUIT_IDS.contains(id) ? 1 : 0) != 0, (Object)"id must be unique");
            return new CustomConduit(id, name);
        }

        private void bindInstance(BiFunction<Component, ResourceLocation, Conduit<?, ?>> factory) {
            Conduit<?, ?> conduit = factory.apply(this.name, this.getTexturePath());
            JsonElement conduitJson = (JsonElement)Conduit.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, conduit).getOrThrow();
            CUSTOM_CONDUITS.put(EnderIO.loc((String)("enderio/conduit/" + this.id)), conduitJson);
            CONDUIT_IDS.add(this.id);
        }

        private ResourceLocation getTexturePath() {
            return EnderIO.loc((String)("block/conduit/" + this.id));
        }
    }

    private static final class Ae2Integration {
        private Ae2Integration() {
        }

        private static BiFunction<Component, ResourceLocation, Conduit<?, ?>> createFactory(String color, boolean dense) {
            AEColor aeColor = AEColor.valueOf((String)color.toUpperCase(Locale.ROOT));
            return (n, t) -> new MEConduit(t, n, aeColor, dense);
        }

        private static boolean isLoaded() {
            return ModList.get().isLoaded("ae2");
        }
    }
}

