/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import net.minecraft.ChatFormatting;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;

public class SkillClientUtils {
    public static boolean isSkillHeldClient(LivingEntity entity, ManasSkill skill) {
        if (!SkillUtils.hasSkill((Entity)entity, skill)) {
            return false;
        }
        if (TensuraSkillCapability.isSkillInSlot(entity, skill, 0)) {
            return TensuraKeybinds.ACTIVATE_SLOT_1.m_90857_();
        }
        if (TensuraSkillCapability.isSkillInSlot(entity, skill, 1)) {
            return TensuraKeybinds.ACTIVATE_SLOT_2.m_90857_();
        }
        if (TensuraSkillCapability.isSkillInSlot(entity, skill, 2)) {
            return TensuraKeybinds.ACTIVATE_SLOT_3.m_90857_();
        }
        return false;
    }

    public static double zoomValue(LivingEntity entity) {
        TensuraSkill farSight;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        double zoom = 0.0;
        TensuraSkill dragonEye = (TensuraSkill)((Object)IntrinsicSkills.DRAGON_EYE.get());
        if (storage.getSkill((ManasSkill)dragonEye).isPresent() && SkillClientUtils.isSkillHeldClient(entity, dragonEye)) {
            zoom += ((ManasSkillInstance)storage.getSkill((ManasSkill)dragonEye).get()).getOrCreateTag().m_128459_("range");
        }
        if (storage.getSkill((ManasSkill)(farSight = (TensuraSkill)((Object)CommonSkills.FARSIGHT.get()))).isPresent() && SkillClientUtils.isSkillHeldClient(entity, farSight)) {
            zoom += ((ManasSkillInstance)storage.getSkill((ManasSkill)farSight).get()).getOrCreateTag().m_128459_("range");
        }
        return zoom;
    }

    public static int getGlowColor(Player player, Entity entity) {
        MobEffectInstance auditorySense;
        MobEffectInstance recon;
        MobEffectInstance dangerDetection;
        MobEffectInstance presenceSense;
        LivingEntity living;
        if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.CAN_STAY_INVISIBLE) && entity.m_20177_(player)) {
            return 0;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)TensuraMobEffects.PRESENCE_CONCEALMENT.get())) {
            return 0;
        }
        ChatFormatting chatFormatting = ChatFormatting.RESET;
        double distance = player.m_20270_(entity);
        MobEffectInstance allSeeing = player.m_21124_((MobEffect)TensuraMobEffects.ALL_SEEING.get());
        if (allSeeing != null) {
            distance -= (double)(10 * (allSeeing.m_19564_() + 1));
        }
        if ((presenceSense = player.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get())) != null && distance <= 30.0) {
            LivingEntity living2;
            if (presenceSense.m_19564_() >= 3) {
                chatFormatting = ChatFormatting.DARK_BLUE;
            } else if (entity instanceof LivingEntity && (living2 = (LivingEntity)entity).m_6084_()) {
                chatFormatting = presenceSense.m_19564_() == 2 ? ChatFormatting.BLUE : (presenceSense.m_19564_() == 1 ? ChatFormatting.AQUA : ChatFormatting.DARK_AQUA);
            }
        }
        if (player.m_21124_((MobEffect)TensuraMobEffects.HEAT_SENSE.get()) != null && distance <= 20.0 && !player.m_9236_().m_6042_().f_63857_()) {
            if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.COLD_SOURCE)) {
                chatFormatting = ChatFormatting.DARK_AQUA;
            } else if (entity instanceof LivingEntity && !entity.m_6095_().m_204039_(TensuraTags.EntityTypes.COLD_BLOODED)) {
                chatFormatting = ChatFormatting.RED;
            }
        }
        if ((dangerDetection = player.m_21124_((MobEffect)TensuraMobEffects.DANGER_DETECTION.get())) != null && dangerDetection.m_19564_() >= 1 && distance <= 50.0) {
            if (entity instanceof NeutralMob) {
                chatFormatting = ChatFormatting.YELLOW;
            } else if (entity instanceof Enemy) {
                chatFormatting = ChatFormatting.DARK_RED;
            }
        }
        if ((recon = player.m_21124_((MobEffect)TensuraMobEffects.REAPER_RECON.get())) != null && distance <= (double)(30 + 20 * recon.m_19564_())) {
            chatFormatting = ChatFormatting.GRAY;
        }
        if ((auditorySense = player.m_21124_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get())) != null && distance <= (double)(20 + 20 * auditorySense.m_19564_()) && !SkillUtils.canBlockSoundDetect(entity) && !entity.m_20067_()) {
            chatFormatting = ChatFormatting.GREEN;
        }
        if (chatFormatting.m_126665_() != null) {
            return chatFormatting.m_126665_();
        }
        return 0;
    }

    public static boolean shouldCancelFireOverlay(LivingEntity living) {
        if (MobEffectHelper.hasTrueInvisibility(living)) {
            return true;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ResistanceSkills.FLAME_ATTACK_NULLIFICATION.get())) {
            return true;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ResistanceSkills.HEAT_NULLIFICATION.get())) {
            return true;
        }
        return SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ResistanceSkills.THERMAL_FLUCTUATION_NULLIFICATION.get());
    }
}

