/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.battlewill.melee;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.registry.battlewill.MeleeArts;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HeavySlashArt
extends Battewill {
    @Override
    public double learningCost() {
        return 80.0;
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        return SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)MeleeArts.AURA_SLASH.get());
    }

    @Override
    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 80.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfAura(entity, instance)) {
            return;
        }
        LivingEntity target = SkillHelper.getTargetingEntity(entity, instance.isMastered(entity) ? 10.0 : 6.0, false);
        Level level = entity.m_9236_();
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        double attack = entity.m_21133_(Attributes.f_22281_);
        if (target != null) {
            TensuraDamageSource source = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)entity), 0.0, instance);
            if (target.m_6469_((DamageSource)source, (float)(attack * 1.5))) {
                SkillHelper.knockBack(entity, target, 2.0f);
                this.addMasteryPoint(instance, entity);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            this.addMasteryPoint(instance, entity);
            this.slash(entity, level, 3.0f, instance);
        }
    }

    private void slash(LivingEntity entity, Level level, float distance, ManasSkillInstance instance) {
        Vec3 target = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_((double)distance));
        Vec3 source = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
        Vec3 sourceToTarget = target.m_82546_(source);
        Vec3 normalizes = sourceToTarget.m_82541_();
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215778_, SoundSource.PLAYERS, 1.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)sourceToTarget.m_82553_()); ++particleIndex) {
            AABB aabb;
            List list;
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123813_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            if (TensuraGameRules.canSkillGrief(level)) {
                SkillHelper.launchBlock((Entity)entity, particlePos, 2, 1, 0.3f, 0.2f, blockState -> {
                    if (entity.m_217043_().m_188503_(2) != 1) {
                        return false;
                    }
                    return blockState.m_204336_(TensuraTags.Blocks.EARTH_MANIPULATING);
                }, pos -> !pos.equals((Object)entity.m_20097_()) && !pos.equals((Object)entity.m_20097_().m_7495_()), instance);
            }
            if ((list = level.m_6443_(LivingEntity.class, aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(2.0), entityData -> !entityData.m_7306_((Entity)entity))).isEmpty()) continue;
            for (LivingEntity living : list) {
                TensuraDamageSource damageSource;
                if (!living.m_6469_((DamageSource)(damageSource = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)entity), 0.0, instance)), (float)(entity.m_21133_(Attributes.f_22281_) * 0.5))) continue;
                TensuraParticleHelper.spawnServerGroundSlamParticle(living, 10, 2.0f);
                living.m_20184_().m_82520_(0.0, 0.3, 0.0);
            }
        }
    }
}

