/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.battlewill.melee;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;

public class RoaringLionPunchArt
extends Battewill {
    @Override
    public double learningCost() {
        return 2000.0;
    }

    @Override
    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        double auraCost;
        if (!entity.m_21205_().m_41619_()) {
            return;
        }
        double d = auraCost = instance.isMastered(entity) ? 4000.0 : 2000.0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            auraCost = Math.min(TensuraPlayerCapability.getAura(player) * 0.1, auraCost);
        }
        if (SkillHelper.outOfAura(entity, auraCost)) {
            return;
        }
        double reach = 3.0 + entity.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get());
        LivingEntity target = SkillHelper.getTargetingEntity(entity, reach, false);
        if (target == null) {
            return;
        }
        Level level = entity.m_9236_();
        float damage = (float)(auraCost / this.auraCost(entity, instance));
        TensuraDamageSource source = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)entity), 0.0, instance);
        target.m_6469_((DamageSource)source, damage);
        SkillHelper.knockBack(entity, target, 0.015f * damage);
        instance.addMasteryPoint(entity);
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

