/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.battlewill.projectile;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.projectile.AuraBulletProjectile;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ElephantStampedeArt
extends Battewill {
    @Override
    public double learningCost() {
        return 1000.0;
    }

    @Override
    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks > 0 && heldTicks % 20 == 0) {
            if (SkillHelper.outOfAura(entity, instance)) {
                return false;
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            if (heldTicks % 40 == 0) {
                instance.addMasteryPoint(entity);
            }
            this.spawnAuraBullets(instance, entity, entity.m_146892_().m_82520_(0.0, 6.0, 0.0));
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_175830_, 1.0);
        return true;
    }

    private void spawnAuraBullets(ManasSkillInstance instance, LivingEntity entity, Vec3 pos) {
        for (int i = 0; i < 8; ++i) {
            Vec3 arrowPos = entity.m_146892_().m_82549_(new Vec3(0.0, 1.0, 0.0).m_82535_(((float)(45 * i) - 22.5f) * ((float)Math.PI / 180)).m_82496_(1.5707964f));
            AuraBulletProjectile bullet = new AuraBulletProjectile(entity.m_9236_(), entity);
            bullet.setSpeed(0.75f);
            bullet.m_146884_(arrowPos);
            bullet.shootFromRot(pos.m_82546_(arrowPos).m_82541_());
            bullet.setDamage(instance.isMastered(entity) ? 50.0f : 25.0f);
            bullet.setExplosionRadius(4.0f);
            bullet.setSize(0.5f);
            bullet.setColor(AuraBulletProjectile.AuraColor.PURPLE);
            bullet.setSkill(instance);
            bullet.setApCost(this.magiculeCost(entity, instance));
            entity.m_9236_().m_7967_((Entity)bullet);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

