/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.battlewill.utility;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ViolentBreakArt
extends Battewill {
    public static ImmutableList<MobEffect> harmfulEffects;

    @Override
    public double learningCost() {
        return 150.0;
    }

    @Override
    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 150.0;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks >= 60) {
            if (SkillHelper.outOfAura(entity, instance)) {
                return false;
            }
            this.addMasteryPoint(instance, entity);
            if (!harmfulEffects.isEmpty()) {
                for (MobEffect effect : harmfulEffects) {
                    SkillHelper.removeLevelsOfEffect(entity, effect, 1);
                }
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.STRENGTHEN.get(), 1200, instance.isMastered(entity) ? 1 : 0, false, false, true));
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 2.0f, 1.0f);
            return false;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:violent_break"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        return true;
    }

    public static void loadConfig() {
        harmfulEffects = ImmutableList.copyOf((Collection)((List)TensuraConfig.INSTANCE.artsConfig.violentBreakEffect.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.MOB_EFFECTS).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

