/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual;

import com.github.manasmods.tensura.ability.magic.Magic;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SpiritualMagic
extends Magic {
    private final MagicElemental elemental;
    private final SpiritLevel level;

    public SpiritualMagic(MagicElemental elemental, SpiritLevel level) {
        super(Magic.MagicType.SPIRITUAL);
        this.elemental = elemental;
        this.level = level;
    }

    @Override
    @Nullable
    public MutableComponent getColoredName() {
        MutableComponent name = super.getColoredName();
        if (name == null) {
            return null;
        }
        return name.m_130940_(this.getElemental().getChatFormatting());
    }

    public int getMaxMastery() {
        return switch (this.getLevel()) {
            default -> throw new IncompatibleClassChangeError();
            case SpiritLevel.LESSER -> 200;
            case SpiritLevel.MEDIUM -> 500;
            case SpiritLevel.GREATER -> 1000;
            case SpiritLevel.LORD -> 2000;
        };
    }

    public MagicElemental getElemental() {
        return this.elemental;
    }

    public SpiritLevel getLevel() {
        return this.level;
    }

    public static enum SpiritLevel {
        LESSER(1, "lesser", ChatFormatting.YELLOW),
        MEDIUM(2, "medium", ChatFormatting.GOLD),
        GREATER(3, "greater", ChatFormatting.RED),
        LORD(4, "lord", ChatFormatting.DARK_RED);

        private static final SpiritLevel[] BY_ID;
        private final int id;
        private final String namespace;
        private final ChatFormatting chatFormatting;

        public static SpiritLevel byId(int id) {
            if (id % 4 == 0) {
                return LORD;
            }
            if (id % 3 == 0) {
                return GREATER;
            }
            if (id % 2 == 0) {
                return MEDIUM;
            }
            return LESSER;
        }

        public MutableComponent getName() {
            return Component.m_237115_((String)("tensura.magic.spiritual.level." + this.namespace));
        }

        public MutableComponent getSpiritName(MagicElemental elemental) {
            if (this.equals((Object)LORD)) {
                return Component.m_237110_((String)"tensura.magic.spiritual.spirit_name.lord", (Object[])new Object[]{this.getName(), elemental.getName()});
            }
            return Component.m_237110_((String)"tensura.magic.spiritual.spirit_name", (Object[])new Object[]{this.getName(), elemental.getName()});
        }

        public int getId() {
            return this.id;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ChatFormatting getChatFormatting() {
            return this.chatFormatting;
        }

        private SpiritLevel(int id, String namespace, ChatFormatting chatFormatting) {
            this.id = id;
            this.namespace = namespace;
            this.chatFormatting = chatFormatting;
        }

        static {
            BY_ID = (SpiritLevel[])Arrays.stream(SpiritLevel.values()).sorted(Comparator.comparingInt(SpiritLevel::getId)).toArray(SpiritLevel[]::new);
        }
    }
}

