/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.darkness;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import com.github.manasmods.tensura.entity.magic.barrier.DarkCubeEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DarkCubeMagic
extends SpiritualMagic {
    public DarkCubeMagic() {
        super(MagicElemental.DARKNESS, SpiritualMagic.SpiritLevel.MEDIUM);
    }

    @Override
    public int defaultCast() {
        return 60;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 800.0;
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (!entity.m_6144_()) {
            return super.onHeld(instance, entity, heldTicks);
        }
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        DarkCubeEntity barrier;
        if (!entity.m_6144_()) {
            return;
        }
        BarrierPart part = SkillHelper.getTargetingEntity(BarrierPart.class, entity, 20.0, 0.1, false, false);
        if (part == null) {
            return;
        }
        BarrierEntity barrierEntity = part.barrier;
        if (barrierEntity instanceof DarkCubeEntity && (barrier = (DarkCubeEntity)barrierEntity).m_37282_() == entity) {
            barrier.m_146870_();
            entity.f_19853_.m_6263_(null, part.m_20185_(), part.m_20186_(), part.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Vec3 pos;
        super.onRelease(instance, entity, heldTicks);
        if (entity.m_6144_()) {
            return;
        }
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        int distance = instance.isMastered(entity) ? 20 : 15;
        LivingEntity target = SkillHelper.getTargetingEntity(entity, distance, false, true);
        if (target != null) {
            pos = target.m_20096_() ? target.m_20182_().m_82520_(0.0, 4.5, 0.0) : target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(entity.f_19853_, (Entity)entity, ClipContext.Fluid.NONE, distance);
            pos = result.m_82450_().m_82520_(0.0, 4.5, 0.0);
        }
        DarkCubeEntity cube = new DarkCubeEntity(entity.m_9236_(), entity);
        cube.m_146884_(pos);
        cube.setDamage(instance.isMastered(entity) ? 20.0f : 10.0f);
        cube.setMpCost(this.magiculeCost(entity, instance));
        cube.setSkill(instance);
        cube.setLife(600);
        cube.setRadius(5.0f);
        entity.m_9236_().m_7967_((Entity)cube);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
        instance.setCoolDown(instance.isMastered(entity) ? 2 : 4);
        instance.getOrCreateTag().m_128405_("HeldTicks", 0);
        instance.markDirty();
    }
}

