/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.earth;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.projectile.StoneShotProjectile;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class EarthStormMagic
extends SpiritualMagic {
    public EarthStormMagic() {
        super(MagicElemental.EARTH, SpiritualMagic.SpiritLevel.MEDIUM);
    }

    @Override
    public int defaultCast() {
        return 120;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 300.0;
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks == 0 && this.alreadyCasting(entity)) {
            return false;
        }
        int castTime = this.castingTime(instance, entity);
        Level level = entity.m_9236_();
        if (heldTicks >= castTime) {
            if (heldTicks == castTime + 1) {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return false;
                }
                this.addMasteryPoint(instance, entity);
            }
            if (heldTicks % 20 == 0) {
                if (heldTicks > castTime && SkillHelper.outOfMagicule(entity, 50.0)) {
                    return false;
                }
                List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(5.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                if (!list.isEmpty()) {
                    for (LivingEntity target : list) {
                        if (target instanceof Player) {
                            Player player = (Player)target;
                            if (player.m_150110_().f_35934_) continue;
                        }
                        if ((double)target.m_217043_().m_188501_() <= 0.3) {
                            target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 0, false, false, false));
                        }
                        this.spawnStoneSpike(instance, entity, target);
                    }
                }
            }
            if (heldTicks % 2 == 0) {
                TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:earth_storm"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
            }
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return heldTicks - castTime <= (instance.isMastered(entity) ? 600 : 300);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.addCastingParticle(instance, player, heldTicks);
        }
        return true;
    }

    private void spawnStoneSpike(ManasSkillInstance instance, LivingEntity owner, LivingEntity target) {
        StoneShotProjectile stoneShot = new StoneShotProjectile(owner.m_9236_(), owner);
        stoneShot.setSpeed(1.0f);
        stoneShot.setDamage(20.0f);
        stoneShot.setMpCost(this.magiculeCost(owner, instance));
        stoneShot.setSkill(instance);
        stoneShot.setSpiritAttack(true);
        stoneShot.m_6034_(target.m_20185_(), target.m_20188_() + 4.0, target.m_20189_());
        owner.m_9236_().m_7967_((Entity)stoneShot);
    }
}

