/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.fire;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.world.TensuraGameRules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class FireMagic
extends SpiritualMagic {
    public FireMagic() {
        super(MagicElemental.FLAME, SpiritualMagic.SpiritLevel.LESSER);
    }

    @Override
    public boolean isInstant(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        Level level = entity.m_9236_();
        if (!TensuraGameRules.canSkillGrief(level)) {
            return;
        }
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 6.0);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = result.m_82425_();
            BlockState state = level.m_8055_(pos);
            if (!(CampfireBlock.m_51321_((BlockState)state) || CandleBlock.m_152845_((BlockState)state) || CandleCakeBlock.m_152910_((BlockState)state))) {
                BlockPos relative = pos.m_121945_(result.m_82434_());
                if (BaseFireBlock.m_49255_((Level)level, (BlockPos)relative, (Direction)entity.m_6350_())) {
                    if (SkillHelper.outOfMagicule(entity, instance)) {
                        return;
                    }
                    this.addMasteryPoint(instance, entity);
                    SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, relative);
                    if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                        return;
                    }
                    BlockState relativeState = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)relative);
                    level.m_7731_(relative, relativeState, 11);
                    level.m_142346_((Entity)entity, GameEvent.f_157797_, pos);
                    MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, relative));
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                this.addMasteryPoint(instance, entity);
                SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, pos);
                if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                    return;
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                level.m_142346_((Entity)entity, GameEvent.f_157792_, pos);
                MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, pos));
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }
}

