/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.fire;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class FlareCircleMagic
extends SpiritualMagic {
    public FlareCircleMagic() {
        super(MagicElemental.FLAME, SpiritualMagic.SpiritLevel.GREATER);
    }

    @Override
    public int defaultCast() {
        return 60;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 2000.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Vec3 pos;
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 20.0, false, true);
        if (target != null) {
            pos = target.m_20182_();
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(entity.f_19853_, (Entity)entity, ClipContext.Fluid.NONE, 20.0);
            pos = result.m_82450_();
        }
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128405_("BarrierID", 0);
        tag.m_128347_("circleX", pos.f_82479_);
        tag.m_128347_("circleY", pos.f_82480_);
        tag.m_128347_("circleZ", pos.f_82481_);
        instance.markDirty();
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks == 0 && this.alreadyCasting(entity)) {
            return false;
        }
        int castTime = this.castingTime(instance, entity);
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        BlockPos pos = new BlockPos(tag.m_128459_("circleX"), tag.m_128459_("circleY"), tag.m_128459_("circleZ"));
        if (heldTicks >= castTime) {
            if (heldTicks == castTime + 1) {
                this.addMasteryPoint(instance, entity);
            }
            BarrierEntity.spawnLastingBarrier((EntityType<? extends BarrierEntity>)((EntityType)TensuraEntityTypes.FLARE_CIRCLE.get()), 80.0f, 5.0f, 7.0f, 30, entity.m_21233_() / 2.0f, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), entity, instance, this.magiculeCost(entity, instance), 1000.0, heldTicks);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return heldTicks - castTime <= (instance.isMastered(entity) ? 200 : 100);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.addCastingParticle(instance, player, heldTicks);
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:flare_circle_circle"), pos, 0.0, 0.0, 0.0, 0, true));
        }
        return true;
    }
}

