/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.light;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.projectile.SolarGrenadeProjectile;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SolarWaveMagic
extends SpiritualMagic {
    public SolarWaveMagic() {
        super(MagicElemental.LIGHT, SpiritualMagic.SpiritLevel.MEDIUM);
    }

    @Override
    public int defaultCast() {
        return 60;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 250.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        SolarGrenadeProjectile grenade = new SolarGrenadeProjectile(entity.m_9236_(), entity);
        grenade.setSpeed(1.0f);
        grenade.setDamage(30.0f);
        grenade.setEffectRange(4.0f);
        grenade.setSpiritAttack(true);
        MobEffectInstance blindness = new MobEffectInstance(MobEffects.f_19610_, 300, instance.isMastered(entity) ? 1 : 0, false, false, false);
        grenade.setMobEffect(blindness);
        grenade.setMpCost(this.magiculeCost(entity, instance));
        grenade.setSkill(instance);
        grenade.setPosAndShoot(entity);
        entity.m_9236_().m_7967_((Entity)grenade);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

