/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.space;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.block.LightAirBlock;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.world.TensuraGameRules;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SpaceMagic
extends SpiritualMagic {
    public SpaceMagic() {
        super(MagicElemental.SPACE, SpiritualMagic.SpiritLevel.LESSER);
    }

    @Override
    public boolean isInstant(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity);
    }

    @Override
    public int defaultCast() {
        return 20;
    }

    @Override
    public int masteryCast() {
        return 1;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks == 0 && this.alreadyCasting(entity)) {
            return false;
        }
        if (this.isInstant(instance, entity) && this.isOnAir(entity)) {
            this.solidSpace(instance, entity);
            return true;
        }
        return super.onHeld(instance, entity, heldTicks);
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        int castingTime = this.castingTime(instance, entity);
        if (castingTime == 0 && this.isOnAir(entity)) {
            return;
        }
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        this.solidSpace(instance, entity);
    }

    private void solidSpace(ManasSkillInstance instance, LivingEntity entity) {
        BlockPos pos;
        BlockPos relative;
        Level level = entity.m_9236_();
        if (!TensuraGameRules.canSkillGrief(level)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        if (this.isOnAir(entity)) {
            if (SkillHelper.outOfMagicule(entity, instance)) {
                return;
            }
            BlockPos belowPos = new BlockPos(entity.m_20185_(), (double)(entity.m_146904_() - 1), entity.m_20189_());
            if (level.m_8055_(belowPos).m_60713_((Block)TensuraBlocks.SOLID_SPACE.get())) {
                return;
            }
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, belowPos);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
            BlockState lightAir = ((Block)TensuraBlocks.SOLID_SPACE.get()).m_49966_();
            level.m_7731_(belowPos, lightAir, 11);
            level.m_142346_((Entity)entity, GameEvent.f_157797_, belowPos);
            level.m_186460_(belowPos, (Block)TensuraBlocks.SOLID_SPACE.get(), 1200);
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, belowPos));
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144048_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return;
        }
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 4.0);
        if (result.m_6662_() != HitResult.Type.ENTITY && (level.m_8055_(relative = (pos = result.m_82425_()).m_121945_(result.m_82434_())).m_60795_() || level.m_8055_(relative).m_60819_().m_192917_((Fluid)Fluids.f_76193_))) {
            if (SkillHelper.outOfMagicule(entity, instance)) {
                return;
            }
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, relative);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
            BlockState lightAir = ((Block)TensuraBlocks.SOLID_SPACE.get()).m_49966_();
            if (level.m_8055_(relative).m_60819_().m_164512_((Fluid)Fluids.f_76193_)) {
                lightAir.m_61124_((Property)LightAirBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            level.m_7731_(relative, lightAir, 11);
            level.m_142346_((Entity)entity, GameEvent.f_157797_, relative);
            if (!instance.isMastered(entity)) {
                level.m_186460_(relative, (Block)TensuraBlocks.SOLID_SPACE.get(), 1200);
            }
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, relative));
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144048_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOnAir(LivingEntity entity) {
        boolean canFly;
        if (!entity.m_6144_()) {
            return false;
        }
        BlockPos belowPos = new BlockPos(entity.m_20185_(), (double)(entity.m_146904_() - 1), entity.m_20189_());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35935_) {
                return false;
            }
        }
        boolean bl = canFly = false;
        if (canFly) {
            return false;
        }
        if (entity.f_19853_.m_8055_(belowPos).m_60795_()) return true;
        if (!entity.f_19853_.m_8055_(belowPos).m_60713_((Block)TensuraBlocks.SOLID_SPACE.get())) return false;
        return true;
    }
}

