/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.space;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SwipeMagic
extends SpiritualMagic {
    public SwipeMagic() {
        super(MagicElemental.SPACE, SpiritualMagic.SpiritLevel.GREATER);
    }

    @Override
    public int defaultCast() {
        return 60;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 5000.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (MobEffectHelper.noTeleportation(entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return;
        }
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        Level level = entity.m_9236_();
        int radius = instance.isMastered(entity) ? 20 : 15;
        Vec3 target = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_((double)radius));
        Vec3 source = entity.m_146892_();
        Vec3 offSetToTarget = target.m_82546_(source);
        Vec3 normalizes = offSetToTarget.m_82541_();
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 1.0f);
        boolean touchedEntity = false;
        float damage = instance.isMastered(entity) ? 500.0f : 200.0f;
        for (int i = 1; i < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++i) {
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)i));
            AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(0.5);
            List list = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity));
            if (list.isEmpty()) continue;
            for (LivingEntity living : list) {
                DamageSource damagesource;
                if (!living.m_6469_((DamageSource)this.sourceWithMP(damagesource = TensuraDamageSources.elementalAttack("tensura.space_attack", (Entity)entity, true), entity, instance).setSpatial(), damage)) continue;
                living.m_19877_();
                living.m_20219_(entity.m_20182_().m_82549_(normalizes.m_82490_(2.0)));
                entity.f_19812_ = true;
                entity.f_19864_ = true;
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)living, (ParticleOptions)ParticleTypes.f_123789_);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)living, (ParticleOptions)ParticleTypes.f_123810_);
                touchedEntity = true;
            }
        }
        if (!touchedEntity) {
            entity.m_183634_();
            entity.m_19877_();
            entity.m_20219_(target);
            entity.f_19812_ = true;
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123789_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123810_);
        }
    }
}

