/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.water;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.magic.spiritual.water.WaterMagic;
import com.github.manasmods.tensura.entity.magic.barrier.MegiddoBubbleEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MegiddoMagic
extends SpiritualMagic {
    public MegiddoMagic() {
        super(MagicElemental.WATER, SpiritualMagic.SpiritLevel.GREATER);
    }

    @Override
    public int defaultCast() {
        return 140;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.megiddo.single");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.megiddo.autonomous");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        if (instance.getMode() == 2) {
            return 30000.0;
        }
        return 3000.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        MegiddoBubbleEntity bubble = this.getMegiddoBubble(entity);
        if (bubble == null) {
            return;
        }
        if (entity.m_6144_()) {
            bubble.m_146870_();
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 60.0, false, true);
        if (target == null) {
            return;
        }
        if (!target.m_6084_()) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, 100.0)) {
            return;
        }
        instance.setCoolDown(1);
        bubble.startNewBeam(target);
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 0.5f, 1.0f);
        instance.getOrCreateTag().m_128405_("HeldTicks", 0);
        instance.markDirty();
    }

    @Override
    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (this.hasMegiddo(entity)) {
            return;
        }
        super.addHeldAttributeModifiers(instance, entity);
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (this.hasMegiddo(entity)) {
            return false;
        }
        return super.onHeld(instance, entity, heldTicks);
    }

    private boolean spawnMegiddoBelow(LivingEntity entity) {
        if (entity.m_6144_()) {
            return false;
        }
        if (entity.m_20096_()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35935_) {
                return false;
            }
        }
        return entity.m_9236_().m_45547_(new ClipContext(entity.m_20182_(), entity.m_20182_().m_82520_(0.0, -10.0, 0.0), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity)).m_6662_() == HitResult.Type.MISS;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (this.hasMegiddo(entity)) {
            return;
        }
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        if (WaterMagic.isWaterEvaporated(entity, entity.f_19853_)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        if (instance.getMode() == 2) {
            instance.setCoolDown(instance.isMastered(entity) ? 10 : 15);
            double yOffset = this.spawnMegiddoBelow(entity) ? -10.0 : 20.0;
            for (int i = 0; i < 9; ++i) {
                int radius = i == 0 ? 3 : 2;
                MegiddoBubbleEntity bubble = this.summonMegiddo(entity, instance, radius, 600);
                bubble.setCharge(bubble.getCharge() / 2);
                bubble.setChainCharge(3);
                Vec3 pos = entity.m_20182_().m_82520_(0.0, yOffset, 0.0);
                if (radius == 2) {
                    Vec3 offset = new Vec3(0.0, 0.0, 15.0).m_82524_(0.0f).m_82496_((float)(i * 45) * ((float)Math.PI / 180)).m_82535_(-1.5707964f).m_82542_(1.0, (double)0.85f, 1.0);
                    pos = pos.m_82549_(offset).m_82520_(0.0, ((double)entity.m_217043_().m_188501_() - 0.5) * 4.0, 0.0);
                }
                bubble.m_146884_(pos);
                entity.m_9236_().m_7967_((Entity)bubble);
                List<LivingEntity> list = bubble.getTargetList(bubble.m_20182_().m_82520_(0.0, -40.0, 0.0), 40.0f);
                if (list.isEmpty()) continue;
                bubble.startNewBeam(list.get(entity.m_217043_().m_188503_(list.size())));
            }
        } else {
            MegiddoBubbleEntity bubble = this.summonMegiddo(entity, instance, 5.0f, 6000);
            bubble.m_6034_(entity.m_20185_(), entity.m_20186_() + 20.0, entity.m_20189_());
            entity.m_9236_().m_7967_((Entity)bubble);
        }
    }

    private MegiddoBubbleEntity summonMegiddo(LivingEntity entity, ManasSkillInstance instance, float radius, int life) {
        MegiddoBubbleEntity bubble = new MegiddoBubbleEntity(entity.m_9236_(), entity);
        if (instance.isMastered(entity)) {
            bubble.setCharge(20);
        }
        bubble.setRadius(radius);
        bubble.setLife(life);
        bubble.setMpCost(this.magiculeCost(entity, instance));
        bubble.setSkill(instance);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return bubble;
    }

    private boolean hasMegiddo(LivingEntity entity) {
        return this.getMegiddoBubble(entity) != null;
    }

    private MegiddoBubbleEntity getMegiddoBubble(LivingEntity owner) {
        AABB bubbleBox = new AABB(new BlockPos(owner.m_20185_(), owner.m_20186_() + 20.0, owner.m_20189_()));
        for (MegiddoBubbleEntity bubble : owner.m_9236_().m_45976_(MegiddoBubbleEntity.class, bubbleBox)) {
            if (bubble.m_37282_() != owner) continue;
            return bubble;
        }
        return null;
    }
}

