/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.wind;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.projectile.WindBladeProjectile;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class WindBladeMagic
extends SpiritualMagic {
    public WindBladeMagic() {
        super(MagicElemental.WIND, SpiritualMagic.SpiritLevel.MEDIUM);
    }

    @Override
    public int defaultCast() {
        return 40;
    }

    @Override
    public int masteryCast() {
        return 20;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity);
    }

    @Override
    public int castingTime(ManasSkillInstance instance, LivingEntity entity) {
        if (this.doubleBlade(instance, entity)) {
            return 0;
        }
        return super.castingTime(instance, entity);
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        WindBladeProjectile blade = new WindBladeProjectile(entity.m_9236_(), entity);
        blade.setSpeed(1.5f);
        blade.setDamage(20.0f);
        blade.setKnockForce(2.0f);
        blade.setMpCost(this.magiculeCost(entity, instance));
        blade.setSkill(instance);
        blade.setSpiritAttack(true);
        blade.m_20242_(true);
        blade.setPosAndShoot(entity);
        entity.m_9236_().m_7967_((Entity)blade);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (instance.isMastered(entity)) {
            if (instance.onCoolDown()) {
                instance.setCoolDown(0);
            } else {
                instance.setCoolDown(2);
            }
        }
    }

    private boolean doubleBlade(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity) && instance.onCoolDown();
    }
}

