/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public class Skill
extends TensuraSkill {
    private final SkillType type;

    public Skill(SkillType type) {
        this.type = type;
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        ResourceLocation id = this.getRegistryName();
        if (id == null) {
            return new ResourceLocation("tensura", "textures/temp_textures/item/confused_rimuru.png");
        }
        return new ResourceLocation("tensura", "textures/skill/" + this.getType().getNamespace() + "/" + id.m_135815_().replace('/', '.') + ".png");
    }

    @Override
    @Nullable
    public MutableComponent getColoredName() {
        MutableComponent name = super.getColoredName();
        if (name == null) {
            return null;
        }
        return name.m_130940_(this.getType().getChatFormatting());
    }

    public int getMaxMastery() {
        return switch (this.getType()) {
            case SkillType.EXTRA -> 500;
            case SkillType.UNIQUE -> 1000;
            case SkillType.ULTIMATE -> 2000;
            default -> 100;
        };
    }

    @Override
    public double getObtainingEpCost() {
        return switch (this.getType()) {
            default -> 100.0;
            case SkillType.EXTRA -> 1000.0;
            case SkillType.UNIQUE -> 10000.0;
            case SkillType.ULTIMATE -> 100000.0;
        };
    }

    @Override
    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (!super.canInteractSkill(instance, entity)) {
            return false;
        }
        return !entity.m_21023_((MobEffect)TensuraMobEffects.ANTI_SKILL.get());
    }

    public SkillType getType() {
        return this.type;
    }

    public static enum SkillType {
        RESISTANCE("resistance", ChatFormatting.DARK_AQUA),
        INTRINSIC("intrinsic", ChatFormatting.AQUA),
        COMMON("common", ChatFormatting.GREEN),
        EXTRA("extra", ChatFormatting.YELLOW),
        UNIQUE("unique", ChatFormatting.GOLD),
        ULTIMATE("ultimate", ChatFormatting.RED);

        private final String namespace;
        private final ChatFormatting chatFormatting;

        public MutableComponent getName() {
            return Component.m_237115_((String)("tensura.skill.type." + this.namespace)).m_130940_(this.chatFormatting);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ChatFormatting getChatFormatting() {
            return this.chatFormatting;
        }

        private SkillType(String namespace, ChatFormatting chatFormatting) {
            this.namespace = namespace;
            this.chatFormatting = chatFormatting;
        }
    }
}

