/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.common;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.magic.field.GravityField;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class GravityFieldSkill
extends Skill {
    public GravityFieldSkill() {
        super(Skill.SkillType.COMMON);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        return newEP > 20000.0;
    }

    @Override
    public double learningCost() {
        return 50.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (this.isMastered(instance, entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 2 -> {
                if (this.isMastered(instance, entity)) {
                    yield 3;
                }
                yield 1;
            }
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.gravity_field.self");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.gravity_field.5");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.gravity_field.10");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(5);
        int fieldLife = this.isMastered(instance, entity) ? 2400 : 1200;
        switch (instance.getMode()) {
            case 1: {
                entity.m_147207_(new MobEffectInstance(MobEffects.f_19596_, fieldLife, 1, false, true), (Entity)entity);
                entity.m_147207_(new MobEffectInstance(MobEffects.f_19591_, fieldLife, 0, false, true), (Entity)entity);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11868_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                GravityField sphere = new GravityField(entity.m_9236_(), entity);
                sphere.setLife(fieldLife);
                sphere.setRadius(6.0f);
                sphere.m_146884_(entity.m_20182_().m_82520_(0.0, -5.0, 0.0));
                entity.m_9236_().m_7967_((Entity)sphere);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11868_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                GravityField sphere = new GravityField(entity.m_9236_(), entity);
                sphere.setLife(fieldLife);
                sphere.setRadius(10.0f);
                sphere.m_146884_(entity.m_20182_().m_82520_(0.0, -10.0, 0.0));
                entity.m_9236_().m_7967_((Entity)sphere);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11868_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

