/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.entity.magic.lightning.BlackLightningBolt;
import com.github.manasmods.tensura.entity.magic.misc.DeathStormTornado;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlackLightningSkill
extends Skill {
    public BlackLightningSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 500.0;
    }

    @Override
    public int modes() {
        return 5;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (!this.canAdvanceModes(entity)) {
            return 0;
        }
        if (reverse) {
            return switch (instance.getMode()) {
                case 5 -> {
                    if (this.isMastered(instance, entity)) {
                        yield 4;
                    }
                    yield 3;
                }
                case 4 -> 3;
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (this.canEquipDeathStorm(entity)) {
                        yield 5;
                    }
                    if (this.isMastered(instance, entity)) {
                        yield 4;
                    }
                    yield 1;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 4 -> {
                if (this.canEquipDeathStorm(entity)) {
                    yield 5;
                }
                yield 1;
            }
            case 3 -> {
                if (this.isMastered(instance, entity)) {
                    yield 4;
                }
                if (this.canEquipDeathStorm(entity)) {
                    yield 5;
                }
                yield 1;
            }
            case 2 -> 3;
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.black_lightning.default");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.black_lightning.weak");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.black_lightning.strong");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.black_lightning.blast");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.black_lightning.storm");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 500.0;
            case 3 -> 1000.0;
            case 5 -> 5000.0;
            default -> 100.0;
        };
    }

    @Override
    public String modeLearningId(int mode) {
        if (mode == 5) {
            return "DeathStorm";
        }
        return "None";
    }

    public boolean canAdvanceModes(LivingEntity entity) {
        return SkillUtils.hasSkill((Entity)entity, (ManasSkill)ExtraSkills.MOLECULAR_MANIPULATION.get());
    }

    public boolean canEquipDeathStorm(LivingEntity entity) {
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)ExtraSkills.WIND_DOMINATION.get())) {
            return true;
        }
        return SkillUtils.hasSkill((Entity)entity, (ManasSkill)ExtraSkills.WIND_MANIPULATION.get());
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getOrCreateTag().m_128451_("StormingTick") > 0;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 4) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        double cost = this.magiculeCost(entity, instance);
        BeamProjectile.spawnLastingBeam((EntityType<? extends BeamProjectile>)((EntityType)TensuraEntityTypes.BLACK_LIGHTNING_BLAST.get()), 25.0f, 1.0f, 21, 30.0f, 2.0f, entity.m_146892_(), entity, instance, cost, cost, heldTicks);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12089_, SoundSource.PLAYERS, 0.8f, 0.5f);
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        int mode = instance.getMode();
        switch (mode) {
            case 4: {
                instance.getOrCreateTag().m_128405_("BeamID", 0);
                instance.markDirty();
                break;
            }
            case 5: {
                CompoundTag tag = instance.getOrCreateTag();
                int learnPoint = tag.m_128451_("DeathStorm");
                if (learnPoint < 100) {
                    tag.m_128405_("DeathStorm", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("DeathStorm") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    return;
                }
                if (tag.m_128451_("StormingTick") > 0) {
                    ServerLevel serverLevel;
                    tag.m_128405_("StormingTick", 0);
                    if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46470_()) {
                        serverLevel.m_8606_(0, 24000, false, false);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12089_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    ServerLevel serverLevel;
                    if (SkillHelper.outOfMagicule(entity, instance)) {
                        return;
                    }
                    this.addMasteryPoint(instance, entity);
                    tag.m_128405_("StormingTick", 30);
                    if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_46470_()) {
                        serverLevel.m_8606_(0, 24000, true, true);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12089_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                instance.markDirty();
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                break;
            }
            default: {
                Vec3 pos;
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 60.0, false, false);
                if (target != null) {
                    pos = target.m_20182_();
                } else {
                    BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 50.0);
                    pos = result.m_82450_();
                }
                BlackLightningBolt bolt = new BlackLightningBolt(level, (Entity)entity);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    bolt.m_20879_(serverPlayer);
                }
                bolt.setMpCost(this.magiculeCost(entity, instance));
                int radius = 0;
                switch (mode) {
                    case 1: {
                        radius = 3;
                        bolt.setTensuraDamage(50.0f);
                        bolt.setAdditionalVisual(4);
                        break;
                    }
                    case 2: {
                        radius = 2;
                        bolt.setTensuraDamage(25.0f);
                        bolt.setAdditionalVisual(2);
                        break;
                    }
                    case 3: {
                        radius = 5;
                        bolt.setTensuraDamage(150.0f);
                        bolt.setAdditionalVisual(6);
                    }
                }
                bolt.setRadius(radius);
                bolt.setSkill(instance);
                bolt.m_146884_(pos);
                level.m_7967_((Entity)bolt);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                this.addMasteryPoint(instance, entity);
            }
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        ServerLevel serverLevel;
        CompoundTag tag = instance.getOrCreateTag();
        Level level = entity.m_9236_();
        int stormTick = tag.m_128451_("StormingTick");
        if (stormTick > 0 && !level.m_46470_()) {
            tag.m_128405_("StormingTick", 0);
            instance.markDirty();
            return;
        }
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), target -> this.deathStormTarget(entity, (LivingEntity)target));
        if (!list.isEmpty()) {
            for (LivingEntity target2 : list) {
                if (entity.m_217043_().m_188499_() || stormTick % 2 != 0 || this.nearTornado(target2)) {
                    BlackLightningBolt bolt = new BlackLightningBolt(level, (Entity)entity);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        bolt.m_20879_(serverPlayer);
                    }
                    bolt.setMpCost(this.magiculeCost(entity, instance) / 50.0);
                    bolt.setTensuraDamage(100.0f);
                    bolt.setAdditionalVisual(2);
                    bolt.setRadius(4.0f);
                    bolt.setSkill(instance);
                    bolt.m_146884_(target2.m_20182_());
                    level.m_7967_((Entity)bolt);
                    continue;
                }
                DeathStormTornado tornado = new DeathStormTornado(level, (Entity)entity);
                tornado.setMpCost(this.magiculeCost(entity, instance) / 50.0);
                tornado.setNewDamage(50.0f);
                tornado.setRadius(4.0f);
                tornado.setSkill(instance);
                tornado.m_146884_(target2.m_20182_());
                level.m_7967_((Entity)tornado);
            }
        } else {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        tag.m_128405_("StormingTick", stormTick - 1);
        instance.markDirty();
        if (tag.m_128451_("StormingTick") > 0) {
            return;
        }
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46470_()) {
            serverLevel.m_8606_(0, 24000, false, false);
        }
    }

    private boolean deathStormTarget(LivingEntity owner, LivingEntity target) {
        if (target == owner) {
            return false;
        }
        if (target.m_7307_((Entity)owner)) {
            return false;
        }
        if (TensuraEPCapability.isTargetNeutral(target, owner)) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            return !player.m_7500_() && !player.m_5833_();
        }
        return target.m_5720_() == SoundSource.HOSTILE || target.m_5720_() == SoundSource.NEUTRAL;
    }

    private boolean nearTornado(LivingEntity entity) {
        return !entity.m_9236_().m_45976_(DeathStormTornado.class, entity.m_20191_().m_82400_(5.0)).isEmpty();
    }
}

