/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.registry.TensuraStats;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class BodyDoubleSkill
extends Skill {
    public BodyDoubleSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 10000.0;
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.IFRIT.get()))) <= 0) {
                return false;
            }
            return TensuraEPCapability.getEP((LivingEntity)entity) >= 100000.0;
        }
        return false;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.body_double.creation");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.body_double.control");
            default -> Component.m_237119_();
        };
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getTag() == null) {
            return false;
        }
        return instance.getTag().m_128441_("Original");
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (!tag.m_128441_("Original")) {
            return;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FRAGILITY.get(), 200, 1, false, false, false));
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ENERGY_BLOCKADE.get(), 200, 4, false, false, false));
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        UUID uuid = tag.m_128342_("Original");
        Entity body = SkillHelper.getEntityFromUUID(level2, uuid, clone -> clone instanceof CloneEntity);
        if (!(body instanceof CloneEntity) || body.m_9236_() != level2 || body.m_20270_((Entity)entity) > 50.0f) {
            entity.m_6469_(TensuraDamageSources.noEnergySource((Entity)entity), entity.m_21233_() * 0.1f);
            DamageSourceHelper.directSpiritualHurt(entity, null, TensuraDamageSources.noEnergySource((Entity)entity), (float)entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * 0.1f, 0.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.mode.body_double.main_too_far").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                player.m_6330_(SoundEvents.f_12511_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        UUID uuid;
        double d;
        Player player;
        if (entity instanceof Player && TensuraPlayerCapability.isSpiritualForm(player = (Player)entity)) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            return;
        }
        Level level = entity.m_9236_();
        if (instance.getMode() == 1) {
            double d2;
            if (entity instanceof Player) {
                Player player2 = (Player)entity;
                d2 = TensuraPlayerCapability.getBaseMagicule(player2);
            } else {
                d2 = TensuraEPCapability.getEP(entity);
            }
            double MP = d2;
            double EP = MP * 0.1;
            if (SkillHelper.outOfMagicule(entity, EP)) {
                return;
            }
            this.addMasteryPoint(instance, entity);
            instance.setCoolDown(instance.isMastered(entity) ? 1 : 3);
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(entity.f_19853_, (Entity)entity, ClipContext.Fluid.NONE, 5.0);
            CloneEntity clone = this.summonClone(entity, level, EP, result.m_82450_());
            CloneEntity.copyEffects(entity, (LivingEntity)clone);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                clone.m_8061_(slot, entity.m_6844_(slot).m_41777_());
            }
            return;
        }
        CloneEntity clone = SkillHelper.getTargetingEntity(CloneEntity.class, entity, 50.0, 0.2, false);
        if (clone == null) {
            return;
        }
        if (!clone.m_21830_(entity)) {
            return;
        }
        if (!clone.m_6084_() || clone.getSkill() != this) {
            return;
        }
        if (entity.m_6144_()) {
            if (!clone.m_6107_()) {
                clone.m_6469_(TensuraDamageSources.noEnergySource((Entity)entity), clone.m_21233_());
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        if (entity instanceof Player) {
            Player player3 = (Player)entity;
            d = TensuraPlayerCapability.getMagicule(player3);
        } else {
            d = TensuraEPCapability.getEP(entity);
        }
        double MP = d;
        CloneEntity newClone = this.summonClone(entity, level, MP, entity.m_20182_());
        CloneEntity.copyEffects(entity, (LivingEntity)newClone);
        newClone.m_21153_(entity.m_21223_());
        entity.m_21153_(clone.m_21223_());
        if (entity instanceof ServerPlayer) {
            ServerPlayer player4 = (ServerPlayer)entity;
            TensuraPlayerCapability.getFrom((Player)player4).ifPresent(cap -> {
                cap.setMagicule(TensuraEPCapability.getEP((LivingEntity)clone));
                TensuraPlayerCapability.sync((Player)player4);
            });
            player4.m_8999_((ServerLevel)level, clone.m_20182_().f_82479_, clone.m_20182_().f_82480_, clone.m_20182_().f_82481_, clone.m_146908_(), clone.m_146909_());
            player4.f_19864_ = true;
        }
        newClone.copyEquipments(entity);
        CloneEntity.copyRotation(entity, (LivingEntity)newClone);
        clone.copyEquipmentsOntoOwner(entity, true);
        CloneEntity.copyEffects((LivingEntity)clone, entity);
        clone.remove();
        CompoundTag tag = instance.getOrCreateTag();
        UUID uUID = uuid = tag.m_128441_("Original") ? tag.m_128342_("Original") : null;
        if (uuid != null && Objects.equals(clone.m_20148_(), uuid)) {
            tag.m_128473_("Original");
        } else {
            newClone.setImmobile(true);
            tag.m_128362_("Original", newClone.m_20148_());
        }
        instance.markDirty();
    }

    private CloneEntity summonClone(LivingEntity entity, Level level, double EP, Vec3 position) {
        EntityType type = entity.m_6144_() ? (EntityType)TensuraEntityTypes.CLONE_SLIM.get() : (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
        CloneEntity clone = new CloneEntity((EntityType<? extends CloneEntity>)type, level);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            clone.m_21828_(player);
        }
        clone.setSkill(this);
        clone.copyStatsAndSkills(entity, true);
        TensuraEPCapability.setLivingEP((LivingEntity)clone, EP);
        clone.m_21153_(clone.m_21233_());
        clone.m_146884_(position);
        CloneEntity.copyRotation(entity, (LivingEntity)clone);
        level.m_7967_((Entity)clone);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, 1.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)clone, (ParticleOptions)ParticleTypes.f_123765_, 1.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)clone, (ParticleOptions)ParticleTypes.f_123765_, 2.0);
        return clone;
    }

    @Override
    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        if (e.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof CloneEntity)) {
            return;
        }
        CloneEntity clone = (CloneEntity)livingEntity;
        if (clone.getSkill() != this) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("Original")) {
            UUID uuid = tag.m_128342_("Original");
            if (Objects.equals(clone.m_20148_(), uuid)) {
                tag.m_128473_("Original");
                instance.markDirty();
                owner.m_6469_(DamageSourceHelper.turnTensura(e.getSource()).setIgnoreBarrier(3.0f).m_19381_(), owner.m_21233_() * 10.0f);
                if (owner.m_6084_() && owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    player.m_8999_((ServerLevel)owner.m_9236_(), clone.m_20182_().f_82479_, clone.m_20182_().f_82480_, clone.m_20182_().f_82481_, clone.m_146908_(), clone.m_146909_());
                    player.f_19864_ = true;
                }
                return;
            }
        }
        if (clone.m_6107_()) {
            return;
        }
        TensuraEPCapability.getFrom((LivingEntity)clone).ifPresent(cap -> {
            SkillHelper.gainMP(owner, cap.getEP(), false);
            cap.setSkipEPDrop(true);
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.ep.acquire_mp", (Object[])new Object[]{cap.getEP()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        });
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_6084_()) {
            return;
        }
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!(entity instanceof Player)) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        if (!tag.m_128441_("Original")) {
            return;
        }
        UUID uuid = tag.m_128342_("Original");
        Entity entity2 = SkillHelper.getEntityFromUUID(level2, uuid, clone -> clone instanceof CloneEntity);
        if (!(entity2 instanceof CloneEntity)) {
            return;
        }
        CloneEntity body = (CloneEntity)entity2;
        tag.m_128473_("Original");
        if (body.m_213877_() || body.m_21223_() <= 0.0f) {
            return;
        }
        entity.m_21153_(Math.max(body.m_21223_(), 1.0f));
        event.setCanceled(true);
        TensuraEffectsCapability.resetEverything(entity, false, false);
        level2.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        CloneEntity clone2 = this.summonClone(entity, (Level)level2, 100.0, entity.m_20182_());
        clone2.copyEquipments(entity);
        instance.addMasteryPoint(entity);
        boolean keepInv = level2.m_46469_().m_46207_(GameRules.f_46133_);
        if (!keepInv) {
            clone2.m_6667_(event.getSource());
            clone2.remove();
        }
        SkillHelper.moveAcrossDimensionTo((Entity)entity, (Entity)body);
        body.copyEquipmentsOntoOwner(entity, true);
        body.remove();
        if (keepInv && (clone2 = (CloneEntity)SkillHelper.moveAcrossDimensionTo((Entity)clone2, (Entity)entity)) != null) {
            clone2.remove();
        }
    }

    public void onRespawn(ManasSkillInstance instance, PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        instance.getOrCreateTag().m_128473_("Original");
        instance.markDirty();
    }
}

