/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.MolecularManipulationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.spike.PillarEntity;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class EarthManipulationSkill
extends Skill {
    public EarthManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 20.0;
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        return TensuraSkillCapability.getSpiritLevel(entity, MagicElemental.EARTH.getId()) >= 1;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.earth_manipulation.wall");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.earth_manipulation.break");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.earth_manipulation.pit");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 3 -> 20.0;
            case 2 -> 10.0;
            case 1 -> 5.0;
            default -> 0.0;
        };
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        MolecularManipulationSkill.learnMolecular(entity);
        if (TensuraEPCapability.getEP(entity) < 400000.0) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)ExtraSkills.EARTH_DOMINATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.EARTH_DOMINATION.get())) {
            return;
        }
        if (DamageSourceHelper.isEarthDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 5.0);
        switch (instance.getMode()) {
            case 1: {
                this.placeWall(instance, entity, level, result);
                break;
            }
            case 2: {
                this.breakWall(instance, entity, level, result);
                break;
            }
            case 3: {
                this.pit(instance, entity, level);
            }
        }
    }

    public void pit(ManasSkillInstance instance, LivingEntity entity, Level level) {
        if (!TensuraGameRules.canSkillGrief(level)) {
            return;
        }
        BlockPos pos = entity.m_20097_();
        int radius = 2;
        boolean success = false;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius * 2; y <= 0; ++y) {
                    BlockPos newPos = pos.m_5487_(Direction.Axis.Y, y).m_5487_(Direction.Axis.X, x).m_5487_(Direction.Axis.Z, z);
                    success = this.breakBlock(level, newPos, entity, instance) || success;
                }
            }
        }
        if (success) {
            this.addMasteryPoint(instance, entity);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
        }
    }

    private void breakWall(ManasSkillInstance instance, LivingEntity entity, Level level, BlockHitResult result) {
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = result.m_82425_();
            if (!level.m_8055_(pos).m_204336_(TensuraTags.Blocks.EARTH_MANIPULATING)) {
                return;
            }
            if (!TensuraGameRules.canSkillGrief(level)) {
                return;
            }
            int radius = 1;
            boolean sucess = false;
            Direction.Axis playerAxis = result.m_82434_().m_122434_();
            Direction.Axis[] axes = (Direction.Axis[])Arrays.stream(Direction.Axis.values()).filter(a -> a != playerAxis).toArray(Direction.Axis[]::new);
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    BlockPos newPos = pos.m_5487_(axes[0], x).m_5487_(axes[1], y);
                    sucess = this.breakBlock(level, newPos, entity, instance) || sucess;
                }
            }
            if (sucess) {
                this.addMasteryPoint(instance, entity);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
            }
        }
    }

    private boolean breakBlock(Level level, BlockPos pos, LivingEntity entity, ManasSkillInstance instance) {
        if (level.m_8055_(pos).m_204336_(TensuraTags.Blocks.EARTH_MANIPULATING)) {
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, pos);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return false;
            }
            boolean success = level.m_46961_(pos, true);
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, pos));
            return success;
        }
        return false;
    }

    private void placeWall(ManasSkillInstance instance, LivingEntity entity, Level level, BlockHitResult result) {
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos clickPos = result.m_82425_();
            if (clickPos.m_123342_() > entity.m_20097_().m_123342_() + 1) {
                return;
            }
            Block block = level.m_8055_(clickPos).m_60734_();
            if (block instanceof TallGrassBlock || block instanceof SeagrassBlock || block instanceof DeadBushBlock) {
                clickPos = clickPos.m_7495_();
            }
            int side = 2;
            Direction direction = entity.m_6350_();
            boolean success = this.placePillars(level, clickPos, entity, instance);
            BlockPos blockPos = clickPos;
            for (int w = 0; w < side; ++w) {
                success = this.placePillars(level, blockPos = blockPos.m_121945_(direction.m_122427_()), entity, instance) || success;
            }
            BlockPos blockPosCounter = clickPos;
            for (int w = 0; w < side; ++w) {
                success = this.placePillars(level, blockPosCounter = blockPosCounter.m_121945_(direction.m_122428_()), entity, instance) || success;
            }
            if (success) {
                this.addMasteryPoint(instance, entity);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
            }
        }
    }

    private boolean placePillars(Level level, BlockPos pos, LivingEntity entity, ManasSkillInstance instance) {
        BlockState state = level.m_8055_(pos);
        if (!state.m_204336_(TensuraTags.Blocks.EARTH_MANIPULATING)) {
            return false;
        }
        Vec3 spawnPos = Vec3.m_82512_((Vec3i)pos.m_7494_()).m_82520_(0.0, -0.5, 0.0);
        List list = level.m_6443_(PillarEntity.class, AABB.m_165882_((Vec3)spawnPos, (double)1.0, (double)1.0, (double)1.0), pillar -> pillar.getOwner() == entity && pillar.getSkill().getSkill() == instance.getSkill());
        if (!list.isEmpty()) {
            return false;
        }
        PillarEntity pillar2 = new PillarEntity(level, entity);
        pillar2.m_146884_(spawnPos);
        pillar2.setDamage(5.0f);
        pillar2.setLife(1200);
        pillar2.setBlockState(state);
        pillar2.setExtendingTick(10);
        pillar2.setHeight(4.0f);
        pillar2.setMpCost(this.magiculeCost(entity, instance));
        pillar2.setSkill(instance);
        entity.m_9236_().m_7967_((Entity)pillar2);
        TensuraParticleHelper.spawnServerParticles(level, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.08, 0.08, 0.08, 0.1, false);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), state.m_60734_().m_49962_(state).m_56777_(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

