/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class HakiSkill
extends Skill {
    private static final String HAKI = "892b7bc5-af0a-4d04-860c-cd7ead8dc2d7";
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.#");

    public HakiSkill() {
        super(Skill.SkillType.EXTRA);
        this.addHeldAttributeModifier(Attributes.f_22279_, HAKI, -0.95f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)CommonSkills.COERCION.get())) {
            return false;
        }
        return newEP > 100000.0;
    }

    @Override
    public double learningCost() {
        return 250.0;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 25.0;
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        ManasSkill skill = (ManasSkill)ExtraSkills.MORTAL_FEAR.get();
        TensuraSkillInstance fear = new TensuraSkillInstance(skill);
        fear.setMastery(-100);
        if (SkillAPI.getSkillsFrom((Entity)entity).learnSkill((ManasSkillInstance)fear) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.9473684210526315 : 1.0);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:haki"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), entityData -> !entityData.m_7306_((Entity)entity) && entityData.m_6084_() && !entity.m_7307_((Entity)entityData));
        if (!list.isEmpty()) {
            double scale = instance.getTag() == null ? 0.0 : instance.getTag().m_128459_("scale");
            double multiplier = scale == 0.0 ? 1.0 : Math.min(scale, 1.0);
            double ownerEP = TensuraEPCapability.getEP(entity) * multiplier;
            for (LivingEntity target : list) {
                double targetEP;
                double difference;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if ((difference = ownerEP / (targetEP = TensuraEPCapability.getEP(target))) <= 2.0) continue;
                int fearLevel = (int)(difference * 0.25 - 0.5);
                fearLevel = Math.min(fearLevel, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.FEAR.get(), 200, fearLevel);
                HakiSkill.hakiPush(target, entity, fearLevel);
            }
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (!this.hasAttributeApplied(entity, Attributes.f_22279_, HAKI)) {
            return;
        }
        instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
    }

    public static void hakiPush(LivingEntity target, LivingEntity source, int fearLevel) {
        if (fearLevel < 1) {
            return;
        }
        double knockResist = 1.0 - target.m_21133_(Attributes.f_22278_);
        double multiplier = Math.min(0.04 * (double)fearLevel, 0.2) * knockResist;
        Vec3 vec3 = target.m_146892_().m_82546_(source.m_146892_()).m_82541_().m_82490_(multiplier);
        target.m_5997_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        HakiSkill.changeEPUsed(instance, entity, delta);
    }

    public static void changeEPUsed(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (!instance.isMastered(entity)) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        double oldScale = tag.m_128459_("scale");
        double newScale = HakiSkill.getNewScale(delta, oldScale);
        if (tag.m_128459_("scale") != newScale) {
            tag.m_128347_("scale", newScale);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.power_scale", (Object[])new Object[]{decimalFormat.format(newScale * 100.0) + "%"}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
            }
            instance.markDirty();
        }
    }

    private static double getNewScale(double delta, double oldScale) {
        double newScale;
        if (oldScale == 0.1) {
            newScale = delta >= 0.0 ? 0.2 : 0.05;
        } else if (oldScale == 0.05) {
            newScale = delta >= 0.0 ? 0.1 : 0.01;
        } else if (oldScale == 0.01) {
            newScale = delta >= 0.0 ? 0.05 : 0.001;
        } else if (oldScale <= 0.001) {
            newScale = delta >= 0.0 ? 0.01 : 1.0;
        } else {
            newScale = oldScale + delta * 0.1;
            if (newScale > 1.0) {
                newScale = 0.001;
            }
        }
        return newScale;
    }
}

