/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.magic.skill.HeatSphereProjectile;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.PacketDistributor;

public class HeatWaveSkill
extends Skill {
    public HeatWaveSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 200.0;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.heat_wave.sphere");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.heat_wave.storm");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 20.0;
            case 1 -> 40.0;
            default -> 0.0;
        };
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 2) {
            return false;
        }
        if (heldTicks % 15 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        float radius = 5.0f;
        entity.f_19853_.m_45976_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius)).stream().filter(target -> !target.m_7306_((Entity)entity) && !target.m_5825_() && target.m_20270_((Entity)entity) <= radius).forEach(target -> {
            target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.heatWave((Entity)entity), entity, instance), 5.0f);
            target.m_20254_(10);
        });
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11936_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:heat_storm"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() != 1) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        HeatSphereProjectile sphere = new HeatSphereProjectile(entity.m_9236_(), entity);
        sphere.setDamage(30.0f);
        sphere.setSpeed(1.0f);
        sphere.setEffectRange(2.5f);
        sphere.setBurnTicks(20);
        sphere.m_20242_(true);
        sphere.setMpCost(this.magiculeCost(entity, instance));
        sphere.setSkill(instance);
        sphere.setPosAndShoot(entity);
        entity.m_9236_().m_7967_((Entity)sphere);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11896_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

