/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.magic.lightning.LightningBolt;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LightningDominationSkill
extends Skill {
    public LightningDominationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)ExtraSkills.LIGHTNING_MANIPULATION.get())) {
            return false;
        }
        return newEP > 400000.0;
    }

    @Override
    public double learningCost() {
        return 20.0;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 20.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (DamageSourceHelper.isLightningDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 4.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        ServerPlayer serverPlayer;
        Vec3 pos;
        Level level = entity.m_9236_();
        if (!level.m_46470_()) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 30.0, false, false);
        if (target != null) {
            pos = target.m_20182_();
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 30.0);
            pos = result.m_82450_();
        }
        LightningBolt bolt = new LightningBolt(level, (Entity)entity);
        bolt.m_20879_(entity instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity) : null);
        bolt.setMpCost(this.magiculeCost(entity, instance));
        bolt.setTensuraDamage(15.0f);
        bolt.setAdditionalVisual(8);
        bolt.setRadius(5.0f);
        bolt.setSkill(instance);
        bolt.m_146884_(pos);
        level.m_7967_((Entity)bolt);
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 1.0f);
    }
}

