/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.entity.magic.lightning.LightningBolt;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LightningManipulationSkill
extends Skill {
    public LightningManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 100.0;
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        return TensuraSkillCapability.getSpiritLevel(entity, MagicElemental.WIND.getId()) >= 3;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 20.0;
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        if (TensuraEPCapability.getEP(entity) < 400000.0) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)ExtraSkills.LIGHTNING_DOMINATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.LIGHTNING_DOMINATION.get())) {
            return;
        }
        if (DamageSourceHelper.isLightningDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        ServerPlayer serverPlayer;
        Vec3 pos;
        Level level = entity.m_9236_();
        if (!level.m_46470_()) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 30.0, false, false);
        if (target != null) {
            pos = target.m_20182_();
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 30.0);
            pos = result.m_82450_();
        }
        LightningBolt bolt = new LightningBolt(level, (Entity)entity);
        bolt.m_20879_(entity instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity) : null);
        bolt.setMpCost(this.magiculeCost(entity, instance));
        bolt.setTensuraDamage(15.0f);
        bolt.setAdditionalVisual(2);
        bolt.setRadius(3.0f);
        bolt.setSkill(instance);
        bolt.m_146884_(pos);
        level.m_7967_((Entity)bolt);
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 1.0f);
    }

    public static void learnLightningManipulation(ManasSkillInstance instance, LivingEntity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        int skills = LightningManipulationSkill.isLightningSKill(instance) ? 1 : 0;
        for (ManasSkillInstance skill : storage.getLearnedSkills()) {
            if (!LightningManipulationSkill.isLightningSKill(skill)) continue;
            ++skills;
        }
        if (skills < 2) {
            return;
        }
        ManasSkill skill = (ManasSkill)ExtraSkills.LIGHTNING_MANIPULATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    private static boolean isLightningSKill(ManasSkillInstance instance) {
        if (instance.isTemporarySkill() || instance.getMastery() < 0) {
            return false;
        }
        if (instance.getSkill().equals(ExtraSkills.WIND_MANIPULATION.get())) {
            return true;
        }
        if (instance.getSkill().equals(ExtraSkills.WIND_DOMINATION.get())) {
            return true;
        }
        if (instance.getSkill().equals(ExtraSkills.BLACK_LIGHTNING.get())) {
            return true;
        }
        return instance.getSkill().equals(IntrinsicSkills.THUNDER_BREATH.get());
    }
}

