/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.Magic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MagicAuraSkill
extends Skill {
    public MagicAuraSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        int magics = 0;
        for (ManasSkillInstance skill : SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills()) {
            if (!(skill.getSkill() instanceof Magic) || !skill.isMastered((LivingEntity)entity)) continue;
            ++magics;
        }
        return magics >= 7;
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    @Override
    public int modes() {
        return 7;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 7 -> 6;
                case 6 -> 5;
                case 5 -> 4;
                case 4 -> 3;
                case 3 -> 2;
                case 2 -> {
                    if (entity.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                        yield 0;
                    }
                    yield 1;
                }
                case 1 -> {
                    if (entity.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                        yield 0;
                    }
                    yield 7;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 7 -> {
                if (entity.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                    yield 0;
                }
                yield 1;
            }
            case 6 -> 7;
            case 5 -> 6;
            case 4 -> 5;
            case 3 -> 4;
            case 2 -> 3;
            case 1 -> {
                if (entity.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                    yield 0;
                }
                yield 2;
            }
            default -> 0;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.magic_aura.default");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.magic_aura.holy");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.magic_aura.earth");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.magic_aura.fire");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.magic_aura.space");
            case 6 -> Component.m_237115_((String)"tensura.skill.mode.magic_aura.water");
            case 7 -> Component.m_237115_((String)"tensura.skill.mode.magic_aura.wind");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return instance.getMode() == 1 ? 500.0 : 1000.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!entity.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
            if (SkillHelper.outOfMagicule(entity, instance)) {
                return;
            }
            this.addMasteryPoint(instance, entity);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_AURA.get(), 6000, 0, false, false, false));
        } else {
            entity.m_21195_((MobEffect)TensuraMobEffects.MAGIC_AURA.get());
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
    }
}

