/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.effect.skill.debuff.MagicInterferenceEffect;
import com.github.manasmods.tensura.effect.template.Transformation;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class MagicJammingSkill
extends Skill {
    public MagicJammingSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (!this.isMastered(instance, attacker)) {
            return;
        }
        if (e.getSource().m_7640_() != attacker) {
            return;
        }
        if (!DamageSourceHelper.isPhysicalAttack(e.getSource())) {
            return;
        }
        LivingEntity target = e.getEntity();
        if (TensuraEPCapability.getEP(target) > TensuraEPCapability.getEP(attacker) * 3.5) {
            return;
        }
        SkillHelper.removePredicateEffect(target, effect -> effect instanceof Transformation);
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12362_, SoundSource.PLAYERS, 1.0f, 1.0f);
        target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 600, 1, false, false, false), (Entity)attacker);
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent e) {
        LivingEntity attacker;
        TensuraDamageSource source;
        DamageSource damageSource;
        if (!instance.isToggled()) {
            return;
        }
        if (!(e.getSource().m_19387_() || (damageSource = e.getSource()) instanceof TensuraDamageSource && (source = (TensuraDamageSource)damageSource).getSkill() != null)) {
            return;
        }
        damageSource = e.getSource().m_7639_();
        if (damageSource instanceof LivingEntity && SkillUtils.reducingResistances(attacker = (LivingEntity)damageSource)) {
            return;
        }
        float multiplier = instance.isMastered(e.getEntity()) ? 3.0f : 2.0f;
        e.setAmount(e.getAmount() / multiplier);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, this.magiculeCost(entity, instance) * 5.0)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_magicule.toggled_off", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            instance.setToggled(false);
            return;
        }
        AABB box = entity.m_20191_().m_82400_(entity.m_6095_().equals(TensuraEntityTypes.CHARYBDIS.get()) ? 30.0 : (instance.isMastered(entity) ? 15.0 : 10.0));
        List list = entity.m_9236_().m_6443_(LivingEntity.class, box, living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
        if (list.isEmpty()) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 10 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
        for (LivingEntity target : list) {
            Player player;
            if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_()) || TensuraEPCapability.getEP(target) > TensuraEPCapability.getEP(entity) * 3.5) continue;
            target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 120, 0, false, false, false), (Entity)entity);
            if (!(target instanceof Player) || MagicInterferenceEffect.canStillFly(player = (Player)target)) continue;
            player.m_20242_(false);
            if (!player.m_150110_().f_35936_) continue;
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

