/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MolecularManipulationSkill
extends Skill {
    public MolecularManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 50.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.molecular_manipulation.block");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.molecular_manipulation.entity");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 5.0;
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance instanceof TensuraSkillInstance) {
            TensuraSkillInstance skillInstance = (TensuraSkillInstance)instance;
            CompoundTag tag = skillInstance.getOrCreateTag();
            double newRange = tag.m_128459_("range") + delta;
            if (newRange > 30.0) {
                newRange = 30.0;
            } else if (newRange < 0.0) {
                newRange = 0.0;
            }
            tag.m_128347_("range", newRange);
            skillInstance.markDirty();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        switch (instance.getMode()) {
            case 1: {
                this.breakBlock(entity, instance);
                break;
            }
            case 2: {
                target = SkillHelper.getTargetingEntity(entity, 30.0, 1.0, false, true);
                if (target == null) {
                    return;
                }
                if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.FULL_GRAVITY_CONTROL)) {
                    return;
                }
                if (!(entity instanceof Player)) ** GOTO lbl14
                player = (Player)entity;
                if (player.m_150110_().f_35934_) ** GOTO lbl20
lbl14:
                // 2 sources

                if (target instanceof Player) {
                    player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (SkillUtils.isSkillToggled(target, (ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get()) || SkillUtils.isSkillToggled(target, (ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get())) {
                    return;
                }
lbl20:
                // 3 sources

                v0 = maxSize = instance.isMastered(entity) != false ? 1.0 : 0.5;
                if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get())) {
                    maxSize += 5.0;
                } else if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get())) {
                    maxSize += 3.0;
                }
                if (target.m_20191_().m_82309_() > maxSize) {
                    return;
                }
                tag = instance.getOrCreateTag();
                tag.m_128362_("target", target.m_20148_());
                range = Math.min(30.0, target.m_20182_().m_82546_(entity.m_146892_()).m_82553_());
                tag.m_128347_("range", (double)((int)range));
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Entity target;
        if (instance.getMode() != 2) {
            return false;
        }
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level2 = (ServerLevel)level;
        CompoundTag tag = instance.getOrCreateTag();
        double range = tag.m_128459_("range");
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.range", (Object[])new Object[]{range}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
        }
        if (tag.m_128441_("target") && (target = level2.m_8791_(tag.m_128342_("target"))) != null) {
            double z;
            double y;
            Vec3 viewVector = entity.m_20252_(1.0f).m_82490_(range);
            double x = entity.m_20185_() + viewVector.f_82479_;
            Vec3 targetPos = new Vec3(x, y = entity.m_20188_() + viewVector.f_82480_, z = entity.m_20189_() + viewVector.f_82481_);
            if (targetPos.m_82554_(target.m_20182_()) <= 6.0) {
                if (heldTicks % 60 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)ParticleTypes.f_123760_, 1.0);
                Vec3 vec3 = targetPos.m_82546_(target.m_20182_()).m_82541_().m_82490_(0.5);
                if (vec3.m_82553_() > 0.2) {
                    target.m_20256_(vec3);
                }
                target.m_183634_();
                target.f_19864_ = true;
            }
        }
        return true;
    }

    private void breakBlock(LivingEntity entity, ManasSkillInstance instance) {
        Level level = entity.m_9236_();
        if (!TensuraGameRules.canSkillGrief(level)) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)player, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, 30.0);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = result.m_82425_();
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(TensuraTags.Blocks.SKILL_UNOBTAINABLE)) {
                return;
            }
            if (state.m_60734_().m_155943_() <= -1.0f) {
                return;
            }
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, pos);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
            state.m_60734_().m_5707_(level, pos, state, player);
            if (MolecularManipulationSkill.isMultiBlock(state)) {
                level.m_46953_(pos, true, (Entity)player);
            } else {
                ShulkerBoxBlockEntity shulker;
                BlockEntity blockentity = level.m_7702_(pos);
                if (blockentity instanceof BeehiveBlockEntity) {
                    BeehiveBlockEntity beehiveblockentity = (BeehiveBlockEntity)blockentity;
                    beehiveblockentity.m_58748_(player, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                }
                if (!(blockentity instanceof ShulkerBoxBlockEntity) || (shulker = (ShulkerBoxBlockEntity)blockentity).m_7983_()) {
                    ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
                    if (!player.m_36356_(stack)) {
                        player.m_36176_(stack, false);
                    }
                    level.m_46953_(pos, false, (Entity)player);
                } else {
                    level.m_46953_(pos, !player.m_7500_(), (Entity)player);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, pos));
            List list = player.f_19853_.m_45976_(ItemEntity.class, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos), (double)2.5, (double)2.5, (double)2.5));
            for (ItemEntity item : list) {
                if (player.m_36356_(item.m_32055_())) {
                    item.m_146870_();
                    continue;
                }
                item.m_20219_(player.m_20182_());
            }
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            level.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 0.5f, 1.0f);
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.08, 0.08, 0.08, 0.1);
        }
    }

    public static void learnMolecular(LivingEntity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        int skills = 0;
        for (ManasSkillInstance skill : storage.getLearnedSkills()) {
            if (!MolecularManipulationSkill.masteredManipulation(skill, entity)) continue;
            ++skills;
        }
        if (skills < 2) {
            return;
        }
        ManasSkill skill = (ManasSkill)ExtraSkills.MOLECULAR_MANIPULATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    private static boolean masteredManipulation(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isMastered(entity)) {
            return false;
        }
        if (instance.getSkill().equals(ExtraSkills.WIND_MANIPULATION.get())) {
            return true;
        }
        if (instance.getSkill().equals(ExtraSkills.WATER_MANIPULATION.get())) {
            return true;
        }
        if (instance.getSkill().equals(ExtraSkills.SPATIAL_MANIPULATION.get())) {
            return true;
        }
        if (instance.getSkill().equals(ExtraSkills.FLAME_MANIPULATION.get())) {
            return true;
        }
        return instance.getSkill().equals(ExtraSkills.EARTH_MANIPULATION.get());
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128473_("target");
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128473_("target");
    }

    public static boolean isMultiBlock(BlockState state) {
        if (state.m_61138_((Property)SlabBlock.f_56353_) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
            return true;
        }
        if (state.m_60734_() instanceof PistonHeadBlock) {
            return true;
        }
        for (Property property : state.m_61147_()) {
            if (property.m_61708_().equals("half")) {
                return true;
            }
            if (!property.m_61708_().equals("part")) continue;
            return true;
        }
        return false;
    }
}

