/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SnakeEyeSkill
extends Skill {
    public SnakeEyeSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 800.0;
    }

    @Override
    public int modes() {
        return 5;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 5 : instance.getMode() - 1;
        }
        return instance.getMode() == 5 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.snake_eye.corrosion");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.snake_eye.poison");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.snake_eye.paralysis");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.snake_eye.petrification");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.snake_eye.insanity");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 80.0;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 20.0, false);
        double ownerEP = TensuraEPCapability.getEP(entity);
        if (target != null) {
            if (target instanceof Player) {
                Player player = (Player)target;
                if (player.m_150110_().f_35934_) {
                    return false;
                }
            }
            if (heldTicks % 100 == 0 && heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12268_, SoundSource.PLAYERS, 1.0f, 1.0f);
            MobEffect effect = switch (instance.getMode()) {
                case 1 -> (MobEffect)TensuraMobEffects.CORROSION.get();
                case 2 -> (MobEffect)TensuraMobEffects.FATAL_POISON.get();
                case 3 -> (MobEffect)TensuraMobEffects.PARALYSIS.get();
                case 4 -> (MobEffect)TensuraMobEffects.PETRIFICATION.get();
                default -> (MobEffect)TensuraMobEffects.INSANITY.get();
            };
            int duration = 2;
            int level = 0;
            MobEffectInstance effectInstance = target.m_21124_(effect);
            if (effectInstance != null) {
                duration = effectInstance.m_19557_() + 2;
                level = duration / 300;
                if (TensuraEPCapability.getEP(target) / ownerEP < 0.5) {
                    level *= 2;
                }
            }
            SkillHelper.checkThenAddEffectSource(target, (Entity)entity, effect, duration, level, false, false, false, true);
        }
        return true;
    }
}

